﻿using PUMA.Helpers;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;

namespace Test.HelpersProject
{
    
    
    /// <summary>
    ///This is a test class for DateHelperTest and is intended
    ///to contain all DateHelperTest Unit Tests
    ///</summary>
    [TestClass()]
    public class DateHelperTest
    {


        private TestContext testContextInstance;

        /// <summary>
        ///Gets or sets the test context which provides
        ///information about and functionality for the current test run.
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }

        #region Additional test attributes
        // 
        //You can use the following additional attributes as you write your tests:
        //
        //Use ClassInitialize to run code before running the first test in the class
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //Use ClassCleanup to run code after all tests in a class have run
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //Use TestInitialize to run code before running each test
        //[TestInitialize()]
        //public void MyTestInitialize()
        //{
        //}
        //
        //Use TestCleanup to run code after each test has run
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion


        /// <summary>
        ///A test for Age
        ///</summary>
        [TestMethod()]
        public void AgeTestYears()
        {
            DateTime from = new DateTime(1964, 06, 17);
            DateTime to = new DateTime(2014, 06, 17);
            string expectedResult = "50 Years";
            if (expectedResult != DateHelper.Age(from, to))
            {
                Assert.Fail("Invalid Age");
            }
            to = new DateTime(2014, 06, 16);
            expectedResult = "49 Years";
            if (expectedResult != DateHelper.Age(from, to))
            {
                Assert.Fail("Invalid Age");
            }
            to = new DateTime(2014, 06, 18);
            expectedResult = "50 Years";
            if (expectedResult != DateHelper.Age(from, to))
            {
                Assert.Fail("Invalid Age");
            }
        }

        [TestMethod()]
        public void AgeTestWeeks()
        {
            DateTime from = new DateTime(1964, 11, 17);
            DateTime to = new DateTime(1965,1, 17);
            string expectedResult = "2 Months";
            if (expectedResult != DateHelper.Age(from, to))
            {
                Assert.Fail("Invalid Age");
            }
            to = new DateTime(1965, 12, 16);
            expectedResult = "8 Weeks";
            if (expectedResult != DateHelper.Age(from, to))
            {
                Assert.Fail("Invalid Age");
            }
            to = new DateTime(2014, 06, 18);
            expectedResult = "2 Months";
            if (expectedResult != DateHelper.Age(from, to))
            {
                Assert.Fail("Invalid Age");
            }
        }
    }
}
