﻿using PUMA.PcehrDataStore.DataAccess;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using PUMA.PcehrDataStore.Schemas;
using System.Collections.ObjectModel;
using System.Data.SqlClient;
using System.Data;

namespace Test.PcehrDataStore.DataAccess
{
    
    
    /// <summary>
    ///This is a test class for MenuDlTest and is intended
    ///to contain all MenuDlTest Unit Tests
    ///</summary>
    [TestClass()]
    public class MenuDlTest
    {


        private TestContext testContextInstance;

        /// <summary>
        ///Gets or sets the test context which provides
        ///information about and functionality for the current test run.
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }

        #region Additional test attributes
        // 
        //You can use the following additional attributes as you write your tests:
        //
        //Use ClassInitialize to run code before running the first test in the class
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //Use ClassCleanup to run code after all tests in a class have run
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //Use TestInitialize to run code before running each test
        //[TestInitialize()]
        //public void MyTestInitialize()
        //{
        //}
        //
        //Use TestCleanup to run code after each test has run
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion


        /// <summary>
        ///A test for GetAll
        ///</summary>
        [TestMethod()]
        public void GetAllMenuTest()
        {
            string getAllMenus = "SELECT * FROM [PUMA].[MENU]";
            DataTable results = new DataTable();
            using (SqlCommand command =  Test.Helpers.DataAccess.TestSqlCommand)
            {
                command.CommandText = getAllMenus;
                SqlDataAdapter resultsAdapter = new SqlDataAdapter(command);
                resultsAdapter.Fill(results);
            }

            MenuDl menuDl = new MenuDl();
            ObservableCollection<Menu> menuItems = menuDl.GetAll();
            if (results.Rows.Count == 0)
            {
                Assert.Fail("No test data exists");
            }
            if (results.Rows.Count != menuItems.Count)
            {
                Assert.Fail("Invalid number of rows returned");
            }
            if (!Test.Helpers.DataAccess.ValidSchemaPolulation<Menu>(results, menuItems))
            {
                Assert.Fail("Menu objects have not been fully populated");
            }
        }
    }
}
