﻿using PUMA.PcehrDataStore.DataAccess;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using PUMA.PcehrDataStore.Schemas;
using System.Data.SqlClient;
using System.Data;
using System.Collections.ObjectModel;

namespace Test.PcehrDataStore.DataAccess
{
    
    
    /// <summary>
    ///This is a test class for PatientMasterOverrideDlTest and is intended
    ///to contain all PatientMasterOverrideDlTest Unit Tests
    ///</summary>
    [TestClass()]
    public class PatientMasterOverrideDlTest
    {


        private TestContext testContextInstance;

        /// <summary>
        ///Gets or sets the test context which provides
        ///information about and functionality for the current test run.
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }

        #region Additional test attributes
        // 
        //You can use the following additional attributes as you write your tests:
        //
        //Use ClassInitialize to run code before running the first test in the class
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //Use ClassCleanup to run code after all tests in a class have run
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //Use TestInitialize to run code before running each test
        //[TestInitialize()]
        //public void MyTestInitialize()
        //{
        //}
        //
        //Use TestCleanup to run code after each test has run
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion


        /// <summary>
        ///A test for Save
        ///</summary>
        [TestMethod()]
        public void SaveTest()
        {
            PatientMasterOverrideDl target = new PatientMasterOverrideDl();
            PatientMasterOverride item = new PatientMasterOverride();
            string removeExistingTest = "DELETE FROM [PUMA].[PatientMasterOverride] WHERE PatientMasterId = '-1'";
            using (SqlCommand command = Test.Helpers.DataAccess.TestSqlCommand)
            {
                command.CommandText = removeExistingTest;
                command.ExecuteNonQuery();
            }

            item.PatientMasterId = -1;
            item.DateOfBirth = new DateTime(2001, 1, 1);
            item.DvaNumber = "DVANumber";
            item.IsMedicareNumberValid = true;
            item.MedicareIrn = "X";
            item.MedicareNumber = "Medicare";
            item.DateModified = new DateTime(2001, 01, 01);

            bool result = target.Save(item);
            if (!result)
            {
                Assert.Fail("Save failed");
            }


            DataTable results = new DataTable();
            string getSavedData = "SELECT * FROM [PUMA].[PatientMasterOverride] WHERE PatientMasterId = '-1'";
            using (SqlCommand command = Test.Helpers.DataAccess.TestSqlCommand)
            {
                command.CommandText = getSavedData;
                SqlDataAdapter resultsAdapter = new SqlDataAdapter(command);
                resultsAdapter.Fill(results);
            }
            if (!Test.Helpers.DataAccess.ValidSchemaPolulation<PatientMasterOverride>(results, new ObservableCollection<PatientMasterOverride> { item }))
            {
                Assert.Fail("Menu objects have not been fully populated");
            }
        }
    }
}
