#Copyright Philip Stalley-Gordon 2011-2012

param(
$AppSiteName = $(throw "USAGE: -AppSiteName is a required parameter"),
$AppSitePath = $(throw "USAGE: -AppSitePath is a required parameter"),
$AppPoolName = $(throw "USAGE: -AppPoolName is a required parameter"),
$HTTPBinding = $(throw "USAGE: -HTTPBinding is a required parameter"),
$NETTCPBinding,
$HTTPSBinding,
$NETMSMQBinding,
$ProcessUserName = $(throw "USAGE: -ProcessUserName is a required parameter"),
$ProcessPassword = $(throw "USAGE: -ProcessPassword is a required parameter"),
$AppServerName,
$AppServerPath
)

Write-Host -----------------------------------
Write-Host 
Write-Host -f Blue Starting $AppSiteName
Write Configuration
Write "Site Name:                   $AppSiteName" 
Write "Site Path:                   $AppSitePath"
Write "Application Poolname:        $AppPoolName"
Write "Http Binding Port:           $HTTPBinding"

if ($NETTCPBinding) {
    Write "Net.Tcp Binding Port:        $NETTCPBinding "
}
if ($HTTPSBinding) {
    Write "HTTPS Binding:        $HTTPSBinding "
}
if ($NETMSMQBinding) {
    Write "Net.MSMQ Binding:        $NETMSMQBinding "
}
Write "Process User Name:           $ProcessUserName"
Write "Process Password:            $ProcessPassword"
if ($AppServerName) {
    Write "Site Application Name:       $AppServerName"
    Write "Site Application Path:       $AppServerPath"
}


Write-Host 
Write-Host 
Write-Host -f DarkYellow Checking and setting folder structures...

if (($AppSitePath) -and (Test-Path $AppSitePath)) {
	Write-Host -f DarkYellow AppSitePath ($AppSitePath) already exists.
}
elseif (($AppSitePath) -and !(Test-Path -Path $AppSitePath -IsValid)){
	Write-Host -f Red AppSitePath ($AppSitePath) is INVALID
} 
elseif ($AppSitePath){
	Write-Host -f DarkYellow Creating AppSitePath ($AppSitePath) ...
	New-Item $AppSitePath -type directory
} 

if (($AppServerPath) -and (Test-Path $AppServerPath)) {
	Write-Host -f DarkYellow AppServerPath ($AppServerPath) already exists.
}
elseif (($AppServerPath) -and !(Test-Path -Path $AppServerPath -IsValid)){
	Write-Host -f Red AppServerPath ($AppServerPath) is INVALID
} 
elseif ($AppServerPath){
	Write-Host -f DarkYellow Creating AppServerPath ($AppServerPath) ...
	New-Item $AppServerPath -type directory
} 


Write-Host 
Write-Host 
Write-Host -f DarkYellow Creating Application Pool...
.$env:WINDIR\system32\inetsrv\appcmd add apppool /name:$AppPoolName  /managedRuntimeVersion:"v4.0" /processModel.identityType:SpecificUser /processModel.userName:$ProcessUserName /processModel.password:$ProcessPassword /processModel.loadUserProfile:true /processModel.idleTimeout:24:00:00 /commit:apphost

Write-Host 
Write-Host -f DarkYellow Creating Application Site...
.$env:WINDIR\system32\inetsrv\appcmd add site /name:$AppSiteName /physicalPath:$AppSitePath /applicationDefaults.applicationPool:$AppPoolName /logFile.localTimeRollover:true /logFile.enabled:true 

if ($HTTPBinding) {
    Write-Host 
    Write-Host -f DarkYellow Adding http Bindings...
    $AppendBinding = "/+bindings.[protocol='http',bindingInformation='*:" + $HTTPBinding + ":']"
    .$env:WINDIR\system32\inetsrv\appcmd set site /site.name:$AppSiteName /applicationDefaults.enabledProtocols:http  $AppendBinding
}

if ($NETTCPBinding) {
    Write-Host 
    Write-Host -f DarkYellow Adding net.tcp Bindings...
    $AppendBinding = "/+bindings.[protocol='net.tcp',bindingInformation='" + $NETTCPBinding + ":*']"
    .$env:WINDIR\system32\inetsrv\appcmd set site /site.name:$AppSiteName /applicationDefaults.enabledProtocols:"http,net.tcp"  $AppendBinding
}

if ($NETMSMQBinding) {
    Write-Host 
    Write-Host -f DarkYellow Adding net.msmq Bindings...
    $AppendBinding = "/+bindings.[protocol='net.msmq',bindingInformation='" + $NETMSMQBinding + "']"
    .$env:WINDIR\system32\inetsrv\appcmd set site /site.name:$AppSiteName /applicationDefaults.enabledProtocols:"http,net.tcp,net.msmq"  $AppendBinding
}

if ($HTTPSBinding) {
    Write-Host 
    Write-Host -f DarkYellow Adding https Bindings...
    $AppendBinding = "/+bindings.[protocol='https',bindingInformation='*:" + $HTTPSBinding + ":']"
    .$env:WINDIR\system32\inetsrv\appcmd set site /site.name:$AppSiteName /applicationDefaults.enabledProtocols:"http,net.tcp,net.msmq,https"  $AppendBinding
}

if (($AppServerName) -and (Test-Path -Path $AppServerPath -IsValid)) {
    Write-Host 
    Write-Host -f DarkYellow Adding Application to Site...
    .$env:WINDIR\system32\inetsrv\appcmd add app /site.name:$AppSiteName /path:/$AppServerName /physicalPath:$AppServerPath 
}

Write-Host 
Write-Host -f DarkYellow Setting default permissions...
.$env:WINDIR\system32\inetsrv\appcmd unlock config $AppSiteName /section:windowsAuthentication /commit:apphost
.$env:WINDIR\system32\inetsrv\appcmd unlock config $AppSiteName /section:anonymousAuthentication /commit:apphost

#.$env:WINDIR\system32\inetsrv\appcmd unlock config $AppServerName /section:windowsAuthentication /commit:apphost
#.$env:WINDIR\system32\inetsrv\appcmd unlock config $AppServerName /section:anonymousAuthentication /commit:apphost
#.$env:WINDIR\system32\inetsrv\appcmd set config $AppServerName /section:anonymousAuthentication /enabled:true
#.$env:WINDIR\system32\inetsrv\appcmd set config $AppServerName /section:windowsAuthentication /enabled:false

.$env:WINDIR\system32\inetsrv\appcmd set config $AppSiteName /section:anonymousAuthentication /enabled:true
.$env:WINDIR\system32\inetsrv\appcmd set config $AppSiteName /section:windowsAuthentication /enabled:false





Write-Host -f Yellow $AppSiteName Complete.
Write-Host 
