﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.ServiceModel;
using System.ServiceModel.Configuration;
using System.Configuration;
using HIPS.IhiSchemas.Schemas;
using HIPS.CommonSchemas;
using HIPS.PcehrSchemas;
using System.Data.SqlClient;
using HIPS.PcehrDataStore.DataAccess;
using HIPS.PcehrDataStore.Schemas;
using HIPS.DemoHarness.Helpers;
using HIPS.DemoHarness.PcehrDataStoreDataSetTableAdapters;
using System.IO;
using System.Xml;
using hipstest.WebServices;
using HIPS.PcehrDataStore.Schemas.Enumerators;
using HIPS.ConsentSchemas;
using HIPS.CommonSchemas.PatientIdentifier;
using System.Security.Principal;
using System.Threading;
using System.DirectoryServices.AccountManagement;
using System.DirectoryServices;
using System.Globalization;
using HIPS.Common.PcehrDataStore.DataAccess;
using Nehta.VendorLibrary.PCEHR;
using System.Diagnostics;
using System.Xml.Xsl;
using System.Reflection;
using HIPS.Client.Proxy;
using HIPS.HpiiSchemas;
using nehta.mcaR50.ProviderSearchForProviderIndividual;
using HIPS.CommonSchemas.Hi;

namespace HIPS.DemoHarness
{
    public partial class DemoHarnessForm : Form
    {
        #region Private Members
        HL7DatabaseDataSet hl7DataSet = new HL7DatabaseDataSet();
        List<PatientMaster> patients = null;
        List<Hospital> hospitals = null;
        List<HospitalCode> hospitalCodes = null;
        List<CodeSystem> codeSystems = null;
        List<Episode> episodes = null;
        List<ClinicalDocument> documents = null;

        bool GainAccessTabLoaded = false;
        bool DocListTabLoaded = false;
        bool DownloadDocTabLoaded = false;
        bool ChangeHistoryTabLoaded = false;

        #endregion
        #region Properties
        /// <summary>
        /// Gets the patients.
        /// </summary>
        private List<PatientMaster> Patients
        {
            get
            {
                if (this.patients == null)
                {
                    this.patients = GetPatients();
                    this.patients = this.patients.OrderBy(result => result.CurrentName.FamilyName).ToList();
                }
                return this.patients;
            }
        }

        /// <summary>
        /// Gets the episodes.
        /// </summary>
        private List<Episode> Episodes
        {
            get
            {
                if (this.episodes == null)
                {
                    this.episodes = GetEpisodes();
                    this.episodes = this.episodes.OrderBy(result => result.AdmissionDate).ToList();
                }
                return this.episodes;
            }
        }

        /// <summary>
        /// Gets the documents for the selected episode.
        /// </summary>
        private List<ClinicalDocument> Documents
        {
            get
            {
                if (this.documents == null)
                {
                    this.documents = GetDocuments();
                    this.documents = this.documents.OrderBy(result => result.SourceSystemSetId).ToList();
                }
                return this.documents;
            }
        }

        /// <summary>
        /// Gets the hospitals.
        /// </summary>
        private List<Hospital> Hospitals
        {
            get
            {
                if (this.hospitals == null)
                {
                    HospitalDl dataAccess = new HospitalDl();
                    this.hospitals = dataAccess.GetAll();
                }
                return this.hospitals;
            }
        }
        private List<HospitalCode> HospitalCodes
        {
            get
            {
                if (this.hospitalCodes == null)
                {
                    HospitalCodeDl dataAccess = new HospitalCodeDl();
                    this.hospitalCodes = dataAccess.GetAll(null);
                }
                return this.hospitalCodes;
            }
        }
        /// <summary>
        /// Gets the code systems.
        /// </summary>
        private List<CodeSystem> CodeSystems
        {
            get
            {
                if (this.codeSystems == null)
                {
                    CodeSystemDl dataAccess = new CodeSystemDl();
                    this.codeSystems = dataAccess.GetAll();
                }
                return this.codeSystems;
            }
        }

        private PatientMaster SelectedPatient
        {
            get
            {
                if (HipsTestHarnessTabControl.SelectedTab == CheckPcehrPage)
                {
                    return tab3PatientComboBox.SelectedItem as PatientMaster;
                }
                else if (HipsTestHarnessTabControl.SelectedTab == UploadSupersedePage)
                {
                    return UploadPatientComboBox.SelectedItem as PatientMaster;
                }
                else if (HipsTestHarnessTabControl.SelectedTab == RecordConsentPage)
                {
                    return ConsentPatientComboBox.SelectedItem as PatientMaster;
                }
                else if (HipsTestHarnessTabControl.SelectedTab == RemoveDocumentPage)
                {
                    return RemovePatientComboBox.SelectedItem as PatientMaster;
                }
                else if (HipsTestHarnessTabControl.SelectedTab == GainAccessPage)
                {
                    return GainAccessPatientComboBox.SelectedItem as PatientMaster;
                }
                else if (HipsTestHarnessTabControl.SelectedTab == DocListPage)
                {
                    return DocListPatientComboBox.SelectedItem as PatientMaster;
                }
                else if (HipsTestHarnessTabControl.SelectedTab == ChangeHistoryPage)
                {
                    return ChangeHistoryPatientComboBox.SelectedItem as PatientMaster;
                }
                else if (HipsTestHarnessTabControl.SelectedTab == DownloadDocumentPage)
                {
                    return DownloadDocPatientComboBox.SelectedItem as PatientMaster;
                }
                return null;
            }
        }

        private Episode SelectedEpisode
        {
            get
            {
                if (HipsTestHarnessTabControl.SelectedTab == UploadSupersedePage)
                {
                    return UploadEpisodeComboBox.SelectedItem as Episode;
                }
                else if (HipsTestHarnessTabControl.SelectedTab == RecordConsentPage)
                {
                    return ConsentEpisodeComboBox.SelectedItem as Episode;
                }
                else if (HipsTestHarnessTabControl.SelectedTab == RemoveDocumentPage)
                {
                    return RemoveEpisodeComboBox.SelectedItem as Episode;
                }
                return null;
            }
        }
        #endregion
        public DemoHarnessForm()
        {
            InitializeComponent();

            ClientSection clientSection = ConfigurationManager.GetSection("system.serviceModel/client") as ClientSection;
            ChannelEndpointElementCollection endpointCollection =
                clientSection.ElementInformation.Properties[string.Empty].Value as ChannelEndpointElementCollection;
            foreach (ChannelEndpointElement endpointElement in endpointCollection)
            {
                string env = endpointElement.Name.Split(new char[] { '_' })[0];
                if (!environmentComboBox.Items.Contains(env))
                {
                    environmentComboBox.Items.Add(env);
                }
            }
            environmentComboBox.SelectedIndex = 0;
            InteractiveUserButton.Checked = true;
            HL7DatabaseDataSetTableAdapters.HL7TestMessagesTableAdapter hl7Adapters = new HL7DatabaseDataSetTableAdapters.HL7TestMessagesTableAdapter();
            hl7Adapters.Fill(hl7DataSet.HL7TestMessages);
            hl7ComboBox.DataSource = hl7DataSet.HL7TestMessages;
            hl7ComboBox.DisplayMember = "Description";
            hl7ComboBox.ValueMember = "HL7Message";
            hl7ComboBox.SelectedIndexChanged += new EventHandler(hl7ComboBox_SelectedIndexChanged);

            SetAuthenticationDetails();
        }

        /// <summary>
        /// Obtains the user's full name, login and domain details and populates them in the text boxes.
        /// </summary>
        private void SetAuthenticationDetails()
        {
            NameTextBox.Text = Environment.UserName;
            LoginTextBox.Text = WindowsIdentity.GetCurrent().Name.Split('\\')[1];
            DomainTextBox.Text = Environment.UserDomainName;
            Thread.GetDomain().SetPrincipalPolicy(PrincipalPolicy.WindowsPrincipal);
            WindowsPrincipal principal = (WindowsPrincipal)Thread.CurrentPrincipal;
            try
            {
                using (PrincipalContext pc = new PrincipalContext(ContextType.Domain))
                {
                    UserPrincipal up = UserPrincipal.FindByIdentity(pc, principal.Identity.Name);
                    NameTextBox.Text = up.DisplayName;
                }
            }
            catch (Exception)
            {
                // Ignore if the domain is not available
            }
        }

        void hl7ComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            inputBox.Text = hl7ComboBox.SelectedValue.ToString();
        }

        private UserDetails GetUser()
        {
            UserDetails user = new UserDetails();

            if (AuthorisedEmployeeButton.Checked)
            {
                user.Role = UserRole.AuthorisedEmployee;
            }
            else if (InteractiveUserButton.Checked)
            {
                user.Role = UserRole.InteractiveUser;
                user.Login = LoginTextBox.Text;
                user.Domain = DomainTextBox.Text;
                user.Name = NameTextBox.Text;
            }
            else if (HealthProviderIndividualButton.Checked)
            {
                user.Role = UserRole.ProviderIndividual;
                user.HpiI = HpiITextBox.Text;
                user.Name = NameTextBox.Text;
            }
            return user;
        }

        DatabaseLoaderServiceClient GetDatabaseLoaderServiceClient()
        {
            string endpointConfigurationName = environmentComboBox.Text + "_DatabaseLoaderService";
            DatabaseLoaderServiceClient client = new DatabaseLoaderServiceClient(endpointConfigurationName);
            return client;
        }

        HIServiceClient GetHIServiceClient()
        {
            string endpointConfigurationName = environmentComboBox.Text + "_IHIService";
            HIServiceClient client = new HIServiceClient(endpointConfigurationName);
            return client;
        }

        PCEHRServiceClient GetPcehrServiceClient()
        {
            string endpointConfigurationName = environmentComboBox.Text + "_PCEHRService";
            PCEHRServiceClient client = new PCEHRServiceClient(endpointConfigurationName);
            return client;
        }

        ConsentServiceClient GetConsentServiceClient()
        {
            string endpointConfigurationName = environmentComboBox.Text + "_ConsentService";
            ConsentServiceClient client = new ConsentServiceClient(endpointConfigurationName);
            return client;
        }

     

        /// <summary>
        /// Handles the Click event of the notifyPasButton control.
        /// </summary>
        /// <param name="sender">The source of the event.</param>
        /// <param name="e">The <see cref="System.EventArgs"/> instance containing the event data.</param>
        private void notifyPasButton_Click(object sender, EventArgs e)
        {
            this.Cursor = Cursors.WaitCursor;
            outputBox.Text = "Processing the Message";
            ClearDatastoreResults();
            SetPanel(StatusPanelType.Status, "Waiting for PAS message to be processed");
            this.Refresh();
            DatabaseLoaderServiceClient client = GetDatabaseLoaderServiceClient();
           
            try
            {
                DateTime submittedTime = DateTime.Now.AddSeconds(-4);
                string text = inputBox.Text;
                inputBox.Text = string.Empty;
                
                outputBox.Text = client.NotifyPasEvent(text.Replace("\r\n", "\r"), GetUser()).Replace("\r", "\r\n");
                
                string mrn = GetMrnFromPasMessage(text);
                string hospitalCode = GetHospitalCode(text);
                GetPatientByHospitalMrn(mrn, hospitalCode);
                SetAuditResults(submittedTime);
                for (int i = 2; i <= NumberOfEpisodes.Value; i++)
                {
                    DateTime admissionDate = GetAdmissionDate(text);

                    string oldDate = admissionDate.ToString("yyyyMMddhhmmss");
                    // create a new mrn
                    //string newMrn = mrn + (i-1).ToString();
                    //TODO: need to change the visit number, not the MRN.
                    // decrement the admission date each time
                    admissionDate = admissionDate.AddDays(i * (-1));
                    string newDate = admissionDate.ToString("yyyyMMhhmmss");
                    string hl7message = text.Replace(oldDate, newDate);
                    hl7message = ChangeVisitNumber(hl7message, i);
                    //hl7message = hl7message.Replace(mrn, newMrn);
                    string response = client.NotifyPasEvent(hl7message.Replace("\r\n", "\r"), GetUser()).Replace("\r", "\r\n");

            //        for (int i = 1; i <= NumberOfDocs; i++)
            //{
            //    string newMrn = MrnPrefix + i.ToString();
            //    //episodeList.Add(new Episode(newMrn, GetCdaDocument(), DateTime.Now.AddDays(i-NumberOfDocs)));
                }
            }
            catch (FaultException<ExceptionDetail> ex)
            {
                outputBox.Text = ex.Message + "\r\n\r\n" + ex.Detail.StackTrace;
            }
            catch (Exception ex)
            {
                outputBox.Text = ex.Message;
            }

            // Always close the client.
            try
            {
                client.Close();
            }
            catch (CommunicationObjectFaultedException)
            {
                // Ignore
            }
            this.Cursor = Cursors.IBeam;
        }
        
        /// <summary>
        /// Returns a new HL7 message with a modified datetime
        /// </summary>
        /// <param name="newAdmissionDate">The new admission date.</param>
        /// <returns></returns>
        private string ChangeVisitNumber(string hl7message, int visit)
        {
            //DateTime result = DateTime.Now;
            //return hl7message.Replace(
            string[] lines = hl7message.Split('\n');
            int i = 0;
            foreach (string line in lines)
            {
                
                int p = line.IndexOf("PV1|");
                if (p > -1)
                {
                    string[] segments = line.Split('|');
                    string admissionDate = segments[44];
                    segments[19] = visit.ToString();
                    lines[i] = String.Join("|", segments);
                    break;
                }
                i++;
            }

            return String.Join("\n", lines);
        }

        class MyFormat : IFormatProvider, ICustomFormatter
        {
            public object GetFormat(Type formatType)
            {
                if (formatType == typeof(ICustomFormatter))
                    return this;
                else
                    return null;
            }

            public string Format(string fmt, object arg, IFormatProvider formatProvider)
            {
                string value = arg as string;
                if (value != null)
                {
                    return "Click to Display";
                }
                return string.Empty;
            }
        }

        private void SetAuditResults(DateTime submittedTime)
        {
            this.ihiLookupAuditTableAdapter.ClearBeforeFill = true;
            this.ihiLookupAuditTableAdapter.Fill(this.pcehrDataStoreDataSet.IhiLookupAudit, submittedTime);
            tab2AuditDataGridView.DataSource = this.pcehrDataStoreDataSet.IhiLookupAudit;
            tab2AuditDataGridView.AutoGenerateColumns = true;


            foreach (DataGridViewColumn col in RemovePcehrAuditGridView.Columns)
            {
                DataGridViewTextBoxColumn textCol = col as DataGridViewTextBoxColumn;
                if (textCol != null)
                {
                    if (textCol.HeaderText == "Request" || textCol.HeaderText == "Response")
                    {
//                        textCol.CellTemplate.Style.FormatProvider = new MyFormat();
                        textCol.DefaultCellStyle.Format = "Click";
                        textCol.MaxInputLength = 1048576;
                    }
                    else if (textCol.HeaderText == "Ihi" || textCol.HeaderText == "HpiO")
                    {
                        textCol.AutoSizeMode = DataGridViewAutoSizeColumnMode.AllCells;
                    }
                }
            }

            try
            {
                this.pcehrAuditTableAdapter.ClearBeforeFill = true;
                this.pcehrAuditTableAdapter.Fill(this.pcehrDataStoreDataSet.PcehrAudit, submittedTime);

                this.pcehrMessageQueueTableAdapter.ClearBeforeFill = true;
                this.pcehrMessageQueueTableAdapter.Fill(this.pcehrDataStoreDataSet.PcehrMessageQueue, submittedTime);
            }
            catch (Exception ex)
            {
                string a = ex.Message;

                // When running against HIPS R1 we get a spurious error here
                if (a != "Invalid object name 'hips.PcehrAudit'.")
                {
                    throw ex;
                }
            }

            UploadPcehrAuditGridView.Refresh();
            RemovePcehrAuditGridView.Refresh();
            UploadQueueGridView.Refresh();

            //UploadPcehrAuditGridView.DataSource = this.pcehrDataStoreDataSet.PcehrAudit;
            //UploadPcehrAuditGridView.AutoGenerateColumns = true;
            //RemovePcehrAuditGridView.DataSource = this.pcehrDataStoreDataSet.PcehrAudit;
            //RemovePcehrAuditGridView.AutoGenerateColumns = true;
        }

        private void notifyPathButton_Click(object sender, EventArgs e)
        {
            this.Cursor = Cursors.WaitCursor;
            outputBox.Text = "Processing the Message";
            outputBox.Refresh();
            DatabaseLoaderServiceClient client = GetDatabaseLoaderServiceClient();

            try
            {
                outputBox.Text = client.NotifyPathEvent(inputBox.Text.Replace("\r\n", "\r"), GetUser()).Replace("\r", "\r\n");
                inputBox.Text = string.Empty;
            }
            catch (FaultException<ExceptionDetail> ex)
            {
                outputBox.Text = ex.Message + "\r\n\r\n" + ex.Detail.StackTrace;
            }
            catch (Exception ex)
            {
                outputBox.Text = ex.Message;
            }

            // Always close the client.
            try
            {
                client.Close();
            }
            catch (CommunicationObjectFaultedException)
            {
                // Ignore
            }
            this.Cursor = Cursors.IBeam;
        }

        private void FormatDate_Click(object sender, EventArgs e)
        {
            try
            {
                outputBox.Text = string.Format(inputBox.Text, DateTime.Now);
            }
            catch (FormatException ex)
            {
                outputBox.Text = ex.Message;
            }
        }

        private void SelectAll(object sender, KeyPressEventArgs e)
        {
            //if ((System.Windows.Forms.Control.ModifierKeys == Keys.Control) && (e.KeyChar == (char)Keys.Select))
            //{
            //    ((TextBox)sender).SelectAll();
            //    e.Handled = true;
            //}
            //else
            //{
            //    outputBox.Text = e.KeyChar.ToString();
            //}
        }

        private void inputBox_KeyDown(object sender, KeyEventArgs e)
        {
            if ((System.Windows.Forms.Control.ModifierKeys == Keys.Control) && (e.KeyCode == Keys.A))
            {
                ((TextBox)sender).SelectAll();
                e.Handled = true;
            }
        }

        private void inputBox_TextChanged(object sender, EventArgs e)
        {
            outputBox.Text = "Message has not been sent yet";
        }

        private void SetVisible(bool value, params Control[] controls)
        {
            foreach (Control c in controls)
            {
                c.Visible = value;
            }
        }

        private void SetAuthorisationParameterVisibility()
        {
            SetVisible(InteractiveUserButton.Checked || HealthProviderIndividualButton.Checked, NameLabel, NameTextBox);
            SetVisible(InteractiveUserButton.Checked, LoginLabel, LoginTextBox, DomainLabel, DomainTextBox);
            SetVisible(HealthProviderIndividualButton.Checked, HpiILabel, HpiITextBox);
        }


        private void InteractiveUserButton_CheckedChanged(object sender, EventArgs e)
        {
            SetAuthorisationParameterVisibility();
        }

        private void HealthProviderIndividualButton_CheckedChanged(object sender, EventArgs e)
        {
            SetAuthorisationParameterVisibility();
        }

        private void AuthorisedEmployeeButton_CheckedChanged(object sender, EventArgs e)
        {
            SetAuthorisationParameterVisibility();
        }

        private void TestHarnessForm_Load(object sender, EventArgs e)
        {
            // TODO: This line of code loads data into the 'pcehrDataStoreDataSet.PcehrAudit' table. You can move, or remove it, as needed.
            //this.pcehrAuditTableAdapter.Fill(this.pcehrDataStoreDataSet.PcehrAudit);
            //// TODO: This line of code loads data into the 'pcehrDataStoreDataSet.PatientMaster' table. You can move, or remove it, as needed.
            this.patientMasterTableAdapter.Fill(this.pcehrDataStoreDataSet.PatientMaster);
            //// TODO: This line of code loads data into the 'pcehrDataStoreDataSet.Patient' table. You can move, or remove it, as needed.
            //this.patientTableAdapter.Fill(this.pcehrDataStoreDataSet.Patient);
            //// TODO: This line of code loads data into the 'pcehrDataStoreDataSet.HospitalCode' table. You can move, or remove it, as needed.
            //this.hospitalCodeTableAdapter.Fill(this.pcehrDataStoreDataSet.HospitalCode);
            //// TODO: This line of code loads data into the 'pcehrDataStoreDataSet.CodeSystem' table. You can move, or remove it, as needed.
            //this.codeSystemTableAdapter.Fill(this.pcehrDataStoreDataSet.CodeSystem);


            DocListStatus.SelectedIndex = 0;


        }

        TextBox[] ResultsTextBoxes
        {
            get
            {
                return new TextBox[]
                {
                    IhiLookupReturnStatusTextBox,
                    IhiTextBox,
                    IhiRecordStatusTextBox,
                    IhiStatusTextBox,
                    LastValidatedDateTimeTextBox,
                    SexTextBox,
                    GivenNamesTextBox,
                    FamilyNameTextBox,
                    AdvertisedStatusTextBox,
                    AccessStatusTextBox,
                    PcehrExistsReturnStatusTextBox,
                    ConsentErrorIndicatorTextBox,
                    RecentParticipationErrorIndicatorTextBox,
                    SinglePatientParticipationErrorIndicatorTextBox
                };
            }
        }

        private void ClearResults()
        {
            foreach (TextBox box in ResultsTextBoxes)
            {
                box.Text = "";
            }
            tab2AuditDataGridView.DataSource = null;
            PatientParticipationGridView.DataSource = null;
//            UploadPcehrAuditGridView.DataSource = null;
        }

        //private void CodeSystemComboBox_SelectedIndexChanged(object sender, EventArgs e)
        //{
        //    //            HospitalCodeComboBox.Text = CodeSystemComboBox.SelectedItem.GetType().ToString();
        //    DataRowView row = (DataRowView)CodeSystemComboBox.SelectedItem;
        //    if (row != null)
        //    {
        //        hospitalCodeBindingSource.Filter = string.Format("CodeSystemId=2");
        //        hospitalCodeBindingSource.Filter = "CodeSystemId=" + row.Row["CodeSystemId"];
        //    }
        //    else
        //    {
        //        hospitalCodeBindingSource.Filter = string.Format("CodeSystemId=2");
        //    }
        //    HospitalCodeComboBox_SelectedIndexChanged(sender, e);
        //}

        //private void HospitalCodeComboBox_SelectedIndexChanged(object sender, EventArgs e)
        //{
        //    DataRowView row = (DataRowView)HospitalCodeComboBox.SelectedItem;
        //    if (row != null)
        //    {
        //        patientBindingSource.Filter = "HospitalId=" + row.Row["HospitalId"];
        //    }
        //    else
        //    {
        //        patientBindingSource.Filter = "1=0";
        //    }
        //    MrnComboBox_SelectedIndexChanged(sender, e);
        //}

        //private void MrnComboBox_SelectedIndexChanged(object sender, EventArgs e)
        //{
        //    DataRowView row = (DataRowView)MrnComboBox.SelectedItem;
        //    if (row != null)
        //    {
        //        patientMasterBindingSource.Filter = "PatientMasterId=" + row.Row["PatientMasterId"];
        //    }
        //    else
        //    {
        //        patientMasterBindingSource.Filter = "1=0";
        //    }
        //    row = (DataRowView)DateOfBirthComboBox.SelectedItem;
        //    if (row != null)
        //    {
        //        DateTime? dateOfBirth = row.Row["DateOfBirth"] as DateTime?;
        //        DateOfBirthPicker.Value = dateOfBirth.Value;
        //    }
        //    else
        //    {
        //        DateOfBirthPicker.Text = "";
        //    }
        //    ClearResults();
        //}

        private void ShowException(Exception ex, TextBox textBox)
        {
            StringBuilder message = new StringBuilder();
            while (ex != null)
            {
                message.AppendLine(ex.GetType().ToString());
                message.AppendLine(ex.Message);
                if (ex is FaultException<ExceptionDetail>)
                {
                    message.AppendLine((ex as FaultException<ExceptionDetail>).Detail.StackTrace);
                }
                message.AppendLine();
                ex = ex.InnerException;
            }
            textBox.Text = message.ToString();
            textBox.Visible = true;
            textBox.BringToFront();
        }

        private void GetValidatedIhiButton_Click(object sender, EventArgs e)
        {
            this.Cursor = Cursors.WaitCursor;
            CheckForPcehrServiceMessagesTextBox.Visible = false;
            CheckForPcehrServiceMessagesTextBox.Text = "";
            HIServiceClient client = GetHIServiceClient();
            try
            {
                string hospitalCode = GetSelectedPatientHospitalCode();
                string hospitalCodeSystem = GetHospitalCodeSystem();
                string mrn = GetSelectedPatientMrn();
                DateTime dateOfBirth = GetSelectedPatientDateOfBirth();
                ValidatedIhiResponse response = client.GetValidatedIhi(new Mrn(mrn, hospitalCode, hospitalCodeSystem), dateOfBirth, GetUser());
                IhiLookupReturnStatusTextBox.Text = response.HipsResponse.ToString();
                ShowResponse(CheckForPcehrServiceMessagesTextBox, response.HipsResponse);
                if (response.ValidatedIhi != null)
                {
                    GivenNamesTextBox.Text = response.ValidatedIhi.GivenName;
                    FamilyNameTextBox.Text = response.ValidatedIhi.FamilyName;
                    SexTextBox.Text = response.ValidatedIhi.Sex.ToString();
                    IhiTextBox.Text = response.ValidatedIhi.Ihi;
                    IhiStatusTextBox.Text = response.ValidatedIhi.IhiStatus.ToString();
                    IhiRecordStatusTextBox.Text = response.ValidatedIhi.IhiRecordStatus.ToString();
                    LastValidatedDateTimeTextBox.Text = string.Format("{0:dd/MM/yyyy HH:mm}", response.ValidatedIhi.IhiLastValidated);
                }
                else
                {
                    GivenNamesTextBox.Text = string.Empty;
                    FamilyNameTextBox.Text = string.Empty;
                    SexTextBox.Text = string.Empty;
                    IhiTextBox.Text = string.Empty;
                    IhiStatusTextBox.Text = string.Empty;
                    IhiRecordStatusTextBox.Text = string.Empty;
                    LastValidatedDateTimeTextBox.Text = string.Empty;
                }
            }
            catch (Exception ex)
            {
                ShowException(ex, CheckForPcehrServiceMessagesTextBox);
            }
            finally
            {
                try
                {
                    client.Close();
                }
                catch (Exception)
                {
                    // Ignore exception while closing client
                }
            }
            this.Cursor = Cursors.Default;
        }

        private string GetSelectedPatientHospitalCode()
        {
            HospitalPatientDl dataAccess = new HospitalPatientDl(GetUser());
            HospitalPatient patient;
            if (SelectedEpisode != null)
            {
                dataAccess.Get(SelectedEpisode.PatientId, out patient);
            }
            else
            {
                // Don't need to match to an episode, doesn't matter which hospital we select.
                patient = dataAccess.GetAll(null, SelectedPatient.PatientMasterId.Value).FirstOrDefault();
            }

            if (patient == null || !patient.PatientId.HasValue)
            {
                return null;
            }
            int? codeSystemId = (from result in CodeSystems where result.Code == GetHospitalCodeSystem() select (result.CodeSystemId)).First();
            string code = (from result in HospitalCodes where result.CodeSystemId == codeSystemId && result.HospitalId == patient.HospitalId select result.Code).First();
            return code;
        }

        /// <summary>
        /// Gets the selected patient MRN.
        /// </summary>
        /// <returns></returns>
        private string GetSelectedPatientMrn()
        {
            HospitalPatientDl dataAccess = new HospitalPatientDl(GetUser());
            HospitalPatient patient;
            if (SelectedEpisode != null)
            {
                dataAccess.Get(SelectedEpisode.PatientId, out patient);
            }
            else
            {
                // Don't need to match to an episode, doesn't matter which hospital we select.
                patient = dataAccess.GetAll(null, SelectedPatient.PatientMasterId.Value).FirstOrDefault();
            }

            if (patient == null || !patient.PatientId.HasValue)
            {
                return null;
            }
            return patient.Mrn;
        }
        /// <summary>
        /// Gets the selected patient date of birth.
        /// </summary>
        /// <returns></returns>
        private DateTime GetSelectedPatientDateOfBirth()
        {
            return SelectedPatient.DateOfBirth;
        }

        private string GetHospitalCodeSystem()
        {
            return "pasFacCd";
        }

        private void CheckPcehrStatusButton_Click(object sender, EventArgs e)
        {
            this.Cursor = Cursors.WaitCursor;
            CheckForPcehrServiceMessagesTextBox.Visible = false;
            CheckForPcehrServiceMessagesTextBox.Text = string.Empty;
            PCEHRServiceClient client = GetPcehrServiceClient();
            try
            {
                string hospitalCode = GetSelectedPatientHospitalCode();
                string codingSystem = GetHospitalCodeSystem();
                string mrn = GetSelectedPatientMrn();
                DateTime dateOfBirth = GetSelectedPatientDateOfBirth();

                DoesPcehrExistResponse response = client.IsPcehrAdvertised(new Mrn(mrn, hospitalCode, GetHospitalCodeSystem()), dateOfBirth, GetUser());
                PcehrExistsReturnStatusTextBox.Text = response.HipsResponse.Status.ToString();
                ShowResponse(CheckForPcehrServiceMessagesTextBox, response.HipsResponse);
                if (response.PcehrExists.HasValue)
                {
                    AdvertisedStatusTextBox.Text = response.PcehrExists.Value ? "Yes, an advertised PCEHR exists." : "No PCEHR exists, or the owner has chosen not to advertise its existence.";
                }
                else
                {
                    AdvertisedStatusTextBox.Text = "Unknown";
                }
                switch (response.AccessCodeRequired)
                {
                    case AccessCodeRequired.Unknown:
                        AccessStatusTextBox.Text = "Unknown";
                        break;
                    case AccessCodeRequired.AccessGranted:
                        AccessStatusTextBox.Text = "Your organisation has already gained access to this PCEHR.";
                        break;
                    case AccessCodeRequired.WithCode:
                        AccessStatusTextBox.Text = "Access to this PCEHR is restricted. You can gain access with the code or assert emergency access.";
                        break;
                    case AccessCodeRequired.WithoutCode:
                        AccessStatusTextBox.Text = "Access to this PCEHR is not restricted. You can gain access without a code.";
                        break;
                }
            }
            catch (Exception ex)
            {
                ShowException(ex, CheckForPcehrServiceMessagesTextBox);
            }
            finally
            {
                try
                {
                    client.Close();
                }
                catch (Exception)
                {
                    // Ignore exception while closing client
                }
            }
            this.Cursor = Cursors.Default;
        }

        /// <summary>
        /// Shows a HIPS response in a text box.
        /// </summary>
        /// <param name="textBox"></param>
        /// <param name="response"></param>
        private void ShowResponse(TextBox textBox, HipsResponse response)
        {
            StringBuilder sb = new StringBuilder();
            sb.AppendFormat("Status: {0}\r\n", response.Status);
            if (!string.IsNullOrEmpty(response.HipsErrorMessage))
            {
                sb.AppendFormat("Message: {0}\r\n", response.HipsErrorMessage);
            }
            if (!string.IsNullOrEmpty(response.ResponseCode))
            {
                sb.AppendFormat("Code: {0}\r\n", response.ResponseCode);
            }
            if (!string.IsNullOrEmpty(response.ResponseCodeDescription))
            {
                sb.AppendFormat("Description: {0}\r\n", response.ResponseCodeDescription);
            }
            if (!string.IsNullOrEmpty(response.ResponseCodeDetails))
            {
                sb.AppendFormat("nDetails: {0}\r\n", response.ResponseCodeDetails);
            }
            textBox.Text = sb.ToString();
            textBox.Visible = true;
        }

        /// <summary>
        /// Clears the datastore results.
        /// </summary>
        private void ClearDatastoreResults()
        {
            tab2DateOfBirthTextBox.Text = string.Empty;
            tab2DvaTextBox.Text = string.Empty;
            tab2FirstNameTextBox.Text = string.Empty;
            tab2IhiRecordStatusTextBox.Text = string.Empty;
            tab2IhiStatusTextBox.Text = string.Empty;
            tab2IhiTextBox.Text = string.Empty;
            tab2IrnTextBox.Text = string.Empty;
            tab2MedicareTextBox.Text = string.Empty;
            tab2SexTextbox.Text = string.Empty;
            tab2DateLastValidatedTextBox.Text = string.Empty;
            tab2PcehrAdvertisedLabel.Text = "PCEHR Advertised - Not Known";
        }

        /// <summary>
        /// Sets the panel.
        /// </summary>
        /// <param name="panelType">Type of the panel.</param>
        /// <param name="message">The message.</param>
        private void SetPanel(StatusPanelType panelType, string message = "")
        {
            switch (panelType)
            {
                case StatusPanelType.Results:
                    tab2StatusPanel.Visible = false;
                    tab2ValidResultsPanel.Visible = true;
                    break;
                default:
                    tab2StatusLabel.Text = message;
                    tab2StatusPanel.Visible = true;
                    tab2ValidResultsPanel.Visible = false;
                    break;
            }
        }

        /// <summary>
        /// Displays the results.
        /// </summary>
        /// <param name="patientMaster">The patient master.</param>
        private void DisplayResults(PatientMaster patientMaster, HealthProviderOrganisationPatient hpop)
        {
            tab2DateOfBirthTextBox.Text = string.Format("{0:dd/MM/yyyy}", patientMaster.DateOfBirth);
            tab2DvaTextBox.Text = patientMaster.DvaNumber;
            tab2FirstNameTextBox.Text = string.Format("{0} {1}", patientMaster.CurrentName.GivenNames, patientMaster.CurrentName.FamilyName);
            tab2IhiRecordStatusTextBox.Text = patientMaster.IhiRecordStatus;
            tab2IhiStatusTextBox.Text = patientMaster.IhiStatus;
            tab2IhiTextBox.Text = patientMaster.Ihi;
            tab2IrnTextBox.Text = patientMaster.MedicareIrn;
            tab2MedicareTextBox.Text = patientMaster.MedicareNumber;
            if (patientMaster.IhiLastValidated != DateTime.MinValue)
            {
                tab2DateLastValidatedTextBox.Text = string.Format("{0:dd/MM/yyyy HH:mm}", patientMaster.IhiLastValidated);
                if (hpop.PcehrAdvertised.HasValue)
                {
                    if (hpop.PcehrAdvertised.Value)
                    {
                        tab2PcehrAdvertisedLabel.Text = "PCEHR is Advertised";
                    }
                    else
                    {
                        tab2PcehrAdvertisedLabel.Text = "PCEHR is not Advertised";
                    }

                }
                else
                {
                    tab2PcehrAdvertisedLabel.Text = "PCEHR Advertised - Not Known";
                }
            }
            else
            {
                tab2PcehrAdvertisedLabel.Text = "IHI Does not exist or cannot be found";
            }

            switch (patientMaster.CurrentSexId)
            {
                case 1:
                    tab2SexTextbox.Text = "Male";
                    break;
                case 2:
                    tab2SexTextbox.Text = "Female";
                    break;
                case 3:
                    tab2SexTextbox.Text = "Intersex/Indeterminate";
                    break;
                case 4:
                    tab2SexTextbox.Text = "Not Specified";
                    break;
            }

        }

        private void GetPatientByHospitalMrn(string mrn, string hospitalCode)
        {
            PatientMaster patientMaster = new PatientMaster();
            PatientMasterDl dataAccess = new PatientMasterDl(GetUser());            
            HospitalDl hospitalDataAccess = new HospitalDl();
            Hospital hospital = hospitalDataAccess.Get(2, hospitalCode);
            bool result = dataAccess.GetByHospitalCodeMrn(mrn, hospitalCode, 2, out patientMaster);
            if (result)
            {
                HealthProviderOrganisationPatientDl hpopDataAccess = new HealthProviderOrganisationPatientDl(GetUser());
                HealthProviderOrganisationPatient hpop;
                hpopDataAccess.Get(hospital.HpiO, patientMaster.PatientMasterId.Value, out hpop);
                DisplayResults(patientMaster, hpop);
                SetPanel(StatusPanelType.Results);

            }
            else
            {
                ClearDatastoreResults();
                SetPanel(StatusPanelType.Status, "Could not find the patient in the PCEHR Data Store");
            }
            //string connection = ConfigurationManager.ConnectionStrings["hipstest.Properties.Settings.PcehrDataStoreConnectionString"].ToString();
            //using (SqlCommand command = new SqlCommand())
            //{
            //    command.Connection = new SqlConnection(connection);
            //    command.CommandType = CommandType.Text;
            //    command.Connection.Open();
            //    //int hospitalId = GetHospitalId(hospitalCode, command);
            //    //int patientMasterId = GetPatientMasterId(mrn, hospitalId, command);
            //    PatientMasterDl da = new PatientMasterDl();
            //    da.Get(
            //}
        }

        /// <summary>
        /// Gets the patient id.
        /// </summary>
        /// <param name="hospitalCode">The hospital code.</param>
        /// <param name="command">The command.</param>
        /// <returns></returns>
        private int GetHospitalId(string hospitalCode, SqlCommand command)
        {
            int result = -1;
            command.CommandText = string.Format("SELECT hc.HospitalId FROM [hips].[HospitalCode] hc WHERE hc.CodeSystemId = 2 AND hc.Code = '{0}'", hospitalCode);
            result = System.Convert.ToInt32(command.ExecuteScalar());
            return result;
        }
        /// <summary>
        /// Gets the patient master id.
        /// </summary>
        /// <param name="mrn">The MRN.</param>
        /// <param name="hospitalId">The hospital id.</param>
        /// <param name="command">The command.</param>
        /// <returns></returns>
        private int GetPatientMasterId(string mrn, int hospitalId, SqlCommand command)
        {
            int result = -1;
            command.CommandText = string.Format("SELECT p.PatientMasterId FROM [hips].[patient] p  WHERE p.Mrn = '{0}' AND p.HospitalId = {1}", mrn, hospitalId);
            result = System.Convert.ToInt32(command.ExecuteScalar());
            return result;
        }

        private string GetMrnFromPasMessage(string pasMessage)
        {
            string result = string.Empty;
            string[] segments = pasMessage.Split('\r', '\n');
            string segment = segments.FirstOrDefault(a => a.StartsWith("PID|"));
            if (segment != null)
            {
                string field = segment.Split('|')[3];
                string repeat = field.Split('~')[0];
                string component = repeat.Split('^')[0];
                result = component;
                result = result.PadLeft(9, '0'); // Pad MRN to 9 characters because HIPS will do the same.
            }
            return result;
        }

        /// <summary>
        /// Gets the admission date.
        /// </summary>
        /// <param name="pasMessage">The pas message.</param>
        /// <returns></returns>
        private DateTime GetAdmissionDate(string pasMessage)
        {
            DateTime result = DateTime.Now; 
            string[] lines = pasMessage.Split('\n');
            foreach (string line in lines)
            {
                int p = line.IndexOf("PV1|");
                if (p > -1)
                {
                    string[] segments = line.Split('|');
                    string admissionDate = segments[44];
                    CultureInfo provider = CultureInfo.InvariantCulture;
                    DateTime objDate = DateTime.ParseExact(admissionDate, "yyyyMMddhhmmss", provider);
                    return objDate;
                }
            }
          
            return result;
        }
        private string GetHospitalCode(string pasMessage)
        {
            string result = string.Empty;
            string[] segments = pasMessage.Split('\r', '\n');
            string segment = segments.FirstOrDefault(a => a.StartsWith("PID|"));
            if (segment != null)
            {
                string field = segment.Split('|')[3];
                string repeat = field.Split('~')[0];
                string component = repeat.Split('^')[3];
                result = component;
            }
            return result;
        }


        private void HipsTestHarnessTabControl_SelectedIndexChanged(object sender, EventArgs e)
        {
            this.SuspendLayout();
            TabControl control = sender as TabControl;
            if (control.SelectedTab == CheckPcehrPage)
            {
                this.Cursor = Cursors.WaitCursor;
                this.patients = null;
                tab3PatientComboBox.DataSource = Patients;
                tab3PatientComboBox.DisplayMember = "CurrentName";
                tab3PatientComboBox.ValueMember = "PatientMasterId";
                this.Cursor = Cursors.Default;
            }
            else if (control.SelectedTab == UploadSupersedePage)
            {
                this.Cursor = Cursors.WaitCursor;
                this.patients = null;
                UploadPatientComboBox.DataSource = Patients;
                UploadPatientComboBox.DisplayMember = "CurrentName";
                UploadPatientComboBox.ValueMember = "PatientMasterId";

                this.Cursor = Cursors.Default;
            }
            else if (control.SelectedTab == RecordConsentPage)
            {
                this.Cursor = Cursors.WaitCursor;
                this.patients = null;
                ConsentPatientComboBox.DataSource = Patients;
                ConsentPatientComboBox.DisplayMember = "CurrentName";
                ConsentPatientComboBox.ValueMember = "PatientMasterId";

                this.Cursor = Cursors.Default;
            }
            else if (control.SelectedTab == RemoveDocumentPage)
            {
                this.Cursor = Cursors.WaitCursor;
                this.patients = null;
                RemovePatientComboBox.DataSource = Patients;
                RemovePatientComboBox.DisplayMember = "CurrentName";
                RemovePatientComboBox.ValueMember = "PatientMasterId";
                RemoveReasonComboBox.DataSource = typeof(RemovalReason).GetEnumValues();
                this.Cursor = Cursors.Default;
            }
            else if (control.SelectedTab == GainAccessPage)
            {
                this.Cursor = Cursors.WaitCursor;
                if (!GainAccessTabLoaded)
                {
                    this.patients = null;
                    GainAccessPatientComboBox.DataSource = Patients;
                    GainAccessPatientComboBox.DisplayMember = "CurrentName";
                    GainAccessPatientComboBox.ValueMember = "PatientMasterId";
                    GainAccessTabLoaded = true;
                }
                this.Cursor = Cursors.Default;
            }
            else if (control.SelectedTab == DocListPage)
            {
                this.Cursor = Cursors.WaitCursor;
                if (!DocListTabLoaded)
                {
                    this.patients = null;
                    DocListPatientComboBox.DataSource = Patients;
                    DocListPatientComboBox.DisplayMember = "CurrentName";
                    DocListPatientComboBox.ValueMember = "PatientMasterId";
                    DocListTabLoaded = true;
                }
                this.Cursor = Cursors.Default;
            }
            else if (control.SelectedTab == ChangeHistoryPage)
            {
                this.Cursor = Cursors.WaitCursor;

                if (!ChangeHistoryTabLoaded)
                {
                    this.patients = null;
                    ChangeHistoryPatientComboBox.DataSource = Patients;
                    ChangeHistoryPatientComboBox.DisplayMember = "CurrentName";
                    ChangeHistoryPatientComboBox.ValueMember = "PatientMasterId";
                    ChangeHistoryTabLoaded = true;
                }
                this.Cursor = Cursors.Default;
            }
            else if (control.SelectedTab == DownloadDocumentPage)
            {
                this.Cursor = Cursors.WaitCursor;

                if (!DownloadDocTabLoaded)
                {
                    this.patients = null;
                    DownloadDocPatientComboBox.DataSource = Patients;
                    DownloadDocPatientComboBox.DisplayMember = "CurrentName";
                    DownloadDocPatientComboBox.ValueMember = "PatientMasterId";
                    DownloadDocTabLoaded = true;
                }
                this.Cursor = Cursors.Default;
            }
            this.ResumeLayout();
        }

        /// <summary>
        /// Gets the patients.
        /// </summary>
        /// <returns></returns>
        private List<PatientMaster> GetPatients()
        {
            this.patientMasterTableAdapter.ClearBeforeFill = true;
            this.patientMasterTableAdapter.Fill(this.pcehrDataStoreDataSet.PatientMaster);
            List<PatientMaster> patientMasterList= new List<PatientMaster>();
            List<HIPS.DemoHarness.PcehrDataStoreDataSet.PatientMasterRow> dataList = pcehrDataStoreDataSet.PatientMaster.ToList();
            foreach (HIPS.DemoHarness.PcehrDataStoreDataSet.PatientMasterRow row in dataList)
            {
                PatientMaster pm = new PatientMaster();
                pm.SetNewCurrentName(null, row.GivenNames, row.FamilyName, null);
                pm.CurrentSexId = row.CurrentSexId;
                pm.DateOfDeath = row.IsDateOfDeathNull() ? null : (DateTime?)row.DateOfDeath;
                pm.DateOfBirth = row.DateOfBirth;
                pm.DvaNumber = row.IsDvaNumberNull() ? null : row.DvaNumber; ;
                pm.PatientMasterId = row.PatientMasterId;
                patientMasterList.Add(pm);
            }
            return patientMasterList;
        }

        /// <summary>
        /// Gets the episodes for the selected patient.
        /// </summary>
        /// <returns></returns>
        private List<Episode> GetEpisodes()
        {
            HospitalPatientDl hospitalPatientDataAccess = new HospitalPatientDl(GetUser());
            List<HospitalPatient> patients = hospitalPatientDataAccess.GetAllActive(SelectedPatient.PatientMasterId.Value);
            EpisodeDl dataAccess = new EpisodeDl(GetUser());
            return patients.SelectMany(a => dataAccess.GetAll(a.PatientId, null)).ToList();
        }

        /// <summary>
        /// Gets the documents for the selected episode.
        /// </summary>
        /// <returns></returns>
        private List<ClinicalDocument> GetDocuments()
        {
            if (SelectedEpisode == null)
            {
                return new List<ClinicalDocument>();
            }

            ClinicalDocumentDl documentDataAccess = new ClinicalDocumentDl(GetUser());

            return documentDataAccess.GetAll(SelectedEpisode.EpisodeId.Value, null);
        }

        private void DateOfBirthLabel_Click(object sender, EventArgs e)
        {

        }

        private void tab3PatientComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            string hospitalCode = GetSelectedPatientHospitalCode();
            string codingSystem = GetHospitalCodeSystem();
            string mrn = GetSelectedPatientMrn();
            ClearResults();
            tab3HospitalCodeReadOnlyTextBox.Text = GetSelectedPatientHospitalCode();
            tab3MrnReadOnlyTextBox.Text = GetSelectedPatientMrn();
            tab3DateOfBirthReadOnlyTextBox4.Text = string.Format("{0:dd/MM/yyyy}", SelectedPatient.DateOfBirth);
            tab3HospitalCodeSystemReadOnlyTextBox.Text = GetHospitalCodeSystem();
            //this.Refresh();
        }

        private void AnyAuditDataGridViewClick(object sender, DataGridViewCellEventArgs e)
        {
            if (e.ColumnIndex < 0)
            {
                return;
            }
            DataGridView view = sender as DataGridView;
            string name = view.Columns[e.ColumnIndex].HeaderText;
            if (name == "Request" || name == "Response")
            {
                string title = string.Format("{0} Message", name);
                MessageForm form = new MessageForm(title, PrintXml(view.CurrentCell.Value.ToString()));
                form.ShowDialog();
            }
            else if (name == "ServiceMessage" || name == "Details")
            {
                MessageForm form = new MessageForm(name, view.CurrentCell.Value.ToString());
                form.ShowDialog();
            }
        }

        private void tab2AuditDataGridView_CellClick(object sender, DataGridViewCellEventArgs e)
        {
            AnyAuditDataGridViewClick(sender, e);

            //DataGridView view = sender as DataGridView;
            //if (e.ColumnIndex == 1 || e.ColumnIndex == 2)
            //{
            //    string title = (e.ColumnIndex == 1) ? "Request Message" : "Response Message";
            //     MessageForm form = new MessageForm(title,PrintXml(view.CurrentCell.Value.ToString()));
            //    form.ShowDialog();
            //}
        }

        /// <summary>
        /// Prints the XML.
        /// </summary>
        /// <param name="xml">The XML.</param>
        /// <returns></returns>
        public string PrintXml(string xml)
        {
            if (!tab2FormatXmlcheckBox.Checked)
            {
                return xml;
            }
            String Result = "";

            using (MemoryStream mStream = new MemoryStream())
            {
                using (XmlTextWriter writer = new XmlTextWriter(mStream, Encoding.Unicode))
                {
                    XmlDocument document = new XmlDocument();

                    try
                    {
                        // Load the XmlDocument with the XML.
                        document.LoadXml(xml);

                        writer.Formatting = Formatting.Indented;

                        // Write the XML into a formatting XmlTextWriter
                        document.WriteContentTo(writer);
                        writer.Flush();
                        mStream.Flush();

                        // Have to rewind the MemoryStream in order to read
                        // its contents.
                        mStream.Position = 0;

                        // Read MemoryStream contents into a StreamReader.
                        StreamReader sReader = new StreamReader(mStream);

                        // Extract the text from the StreamReader.
                        String FormattedXML = sReader.ReadToEnd();

                        Result = FormattedXML;
                    }
                    catch (XmlException)
                    {
                    }

                    writer.Close();
                }
                mStream.Close();
            }

            return Result;


        }

        private Attachment uploadRootDocument;
//        private List<Attachment> attachments = new List<Attachment>();

        private void UploadSelectDocumentButton_Click(object sender, EventArgs e)
        {
            OpenFileDialog dialog = new OpenFileDialog();
            dialog.Filter = "CDA Document (*.xml)|*.xml";
            DialogResult result = dialog.ShowDialog(this);
            if (result == DialogResult.OK)
            {
                try
                {
                    uploadRootDocument = new Attachment();
                    uploadRootDocument.FilePath = dialog.FileName;
                    UploadCdaDocumentTextBox.Text = string.Format("{0} ({1} bytes)", uploadRootDocument.FileName, uploadRootDocument.FileSize);
                    UploadOrSupersedeButton.Enabled = true;
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.Message);
                }
            }
        }

        private void UploadAddAttachmentButton_Click(object sender, EventArgs e)
        {
            OpenFileDialog dialog = new OpenFileDialog();
            dialog.Filter = "PCEHR Supported Attachment|*.gif;*.jpg;*.jpeg;*.png;*.tif;*.tiff;*.pdf|Graphics Interchange Format|*.gif|Joint Photographic Experts Group|*.jpg;*.jpeg|Portable Network Graphics|*.png|Tagged Image File Format|*.tif;*.tiff|Portable Document Format|*.pdf";
            DialogResult result = dialog.ShowDialog(this);
            if (result == DialogResult.OK)
            {
                foreach (string path in dialog.FileNames)
                {
                    Attachment attachment = new Attachment() { FilePath = path };
                    attachmentBindingSource.Add(attachment);
                }
            }
        }

        private void UploadOrSupersedeButton_Click(object sender, EventArgs e)
        {
            submittedTime = DateTime.Now.AddSeconds(-4);
            UploadGetAuditsButton.Enabled = true;
            int numAttachments = attachmentBindingSource.Count;
            HIPS.PcehrSchemas.Attachment[] attachments = new HIPS.PcehrSchemas.Attachment[attachmentBindingSource.Count];
            for (int i = 0; i < numAttachments; i++)
            {
                Attachment attachment = attachmentBindingSource[i] as Attachment;
                attachments[i] = new PcehrSchemas.Attachment()
                {

                    FileName = attachment.FileName,
                    Contents = attachment.Contents
                };
            }

            this.Cursor = Cursors.WaitCursor;
            UploadServiceMessagesTextBox.Visible = false;
            UploadServiceMessagesTextBox.Text = "";
            PCEHRServiceClient client = GetPcehrServiceClient();
            try
            {
                byte[] cdaDocument = uploadRootDocument.Contents;
                string hospitalCode = GetSelectedPatientHospitalCode();
                string hospitalCodeSystem = GetHospitalCodeSystem();
                string mrn = GetSelectedPatientMrn();
                UserDetails user = GetUser();
                DateTime admissionDate = SelectedEpisode.AdmissionDate;

                HipsResponse response = client.UploadOrSupersedeDocument(cdaDocument, new Mrn(mrn, hospitalCode, hospitalCodeSystem), user, attachments, admissionDate);

                UploadReturnStatusTextBox.Text = response.ToString();

                SetAuditResults(submittedTime);
            }
            catch (Exception ex)
            {
                ShowException(ex, UploadServiceMessagesTextBox);
            }
            finally
            {
                try
                {
                    client.Close();
                }
                catch (Exception)
                {
                    // Ignore exception while closing client
                }
            }
            this.Cursor = Cursors.Default;
        }

        private void UploadPatientComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            string hospitalCode = GetSelectedPatientHospitalCode();
            string codingSystem = GetHospitalCodeSystem();
            string mrn = GetSelectedPatientMrn();
            ClearResults();
            UploadHospitalCodeTextBox.Text = GetSelectedPatientHospitalCode();
            UploadMrnTextBox.Text = GetSelectedPatientMrn();
            UploadHospitalCodeSystemTextBox.Text = GetHospitalCodeSystem();

            this.episodes = null;
            UploadEpisodeComboBox.DataSource = Episodes;
            UploadEpisodeComboBox.DisplayMember = "AdmissionDate";
            UploadEpisodeComboBox.ValueMember = "AdmissionDate";
        }

        private void UploadEpisodeComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            ClearResults();
            UploadAdmissionDateTextBox.Text = string.Format("{0:dd/MM/yyyy HH:mm:ss}", SelectedEpisode.AdmissionDate);
            UploadHospitalCodeTextBox.Text = GetSelectedPatientHospitalCode();
            UploadMrnTextBox.Text = GetSelectedPatientMrn();
        }

        private void ConsentPatientComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            ClearResults();
            ConsentHospitalCodeTextBox.Text = SinglePatientParticipationHospitalCodeTextBox.Text = GetSelectedPatientHospitalCode();
            ConsentHospitalCodeSystemTextBox.Text = SinglePatientParticipationHospitalCodeSystemTextBox.Text = GetHospitalCodeSystem();
            ConsentMrnTextBox.Text = SinglePatientParticipationMrnTextBox.Text = GetSelectedPatientMrn();
            this.episodes = null;
            ConsentEpisodeComboBox.Text = "";
            ConsentEpisodeComboBox.DataSource = Episodes;
            ConsentEpisodeComboBox.DisplayMember = "AdmissionDate";
            ConsentEpisodeComboBox.ValueMember = "AdmissionDate";
            RecordConsentButton.Enabled = Episodes.Count > 0;
            SinglePatientParticipationButton.Enabled = Episodes.Count > 0;
        }

        private void ConsentEpisodeComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            ClearResults();
            string admissionDate = string.Format("{0:dd/MM/yyyy HH:mm:ss}", SelectedEpisode.AdmissionDate);
            ConsentAdmissionDateTextBox.Text = admissionDate;
            UploadHospitalCodeTextBox.Text = GetSelectedPatientHospitalCode();
            UploadMrnTextBox.Text = GetSelectedPatientMrn();
        }

        private void RecentParticipationDatePicker_ValueChanged(object sender, EventArgs e)
        {
            RecentHospitalCodeSystemTextBox.Text = GetHospitalCodeSystem();
            RecentSinceDateTextBox.Text = string.Format("{0:dd/MM/yyyy HH:mm:ss}", RecentParticipationDatePicker.Value);
        }

        private void RecordConsentButton_Click(object sender, EventArgs e)
        {
            ConsentServiceMessagesTextBox.Visible = false;
            ConsentServiceMessagesTextBox.Text = "";

            this.Cursor = Cursors.WaitCursor;
            ConsentServiceClient client = GetConsentServiceClient();
            try
            {
                string hospitalCode = GetSelectedPatientHospitalCode();
                string codingSystem = GetHospitalCodeSystem();
                string mrn = GetSelectedPatientMrn();
                bool consent = WithdrawConsentRadioButton.Checked;                
                UserDetails user = GetUser();
                DateTime admissionDate = SelectedEpisode.AdmissionDate;

                HipsResponse response = client.RecordConsent(consent, new Mrn(mrn, hospitalCode, codingSystem), admissionDate, user, null);

                ConsentErrorIndicatorTextBox.Text = response.ToString();
            }
            catch (Exception ex)
            {
                ShowException(ex, ConsentServiceMessagesTextBox);
            }
            finally
            {
                try
                {
                    client.Close();
                }
                catch (Exception)
                {
                    // Ignore exception while closing client
                }
            }
            this.Cursor = Cursors.Default;
        }

        private void ListRecentParticipationButton_Click(object sender, EventArgs e)
        {
            ConsentServiceMessagesTextBox.Visible = false;
            ConsentServiceMessagesTextBox.Text = "";

            this.Cursor = Cursors.WaitCursor;
            ConsentServiceClient client = GetConsentServiceClient();
            try
            {
                string codingSystem = GetHospitalCodeSystem();
                UserDetails user = GetUser();
                DateTime since = RecentParticipationDatePicker.Value;

                PatientParticipationResponse response = client.GetRecentPatientParticipationStatus(since, codingSystem, user);

                RecentParticipationErrorIndicatorTextBox.Text = response.Response.ToString();
                PatientParticipationGridView.DataSource = response.PatientParticipationList;
                PatientParticipationGridView.Columns["ExtensionData"].Visible = false;
            }
            catch (Exception ex)
            {
                ShowException(ex, ConsentServiceMessagesTextBox);
            }
            finally
            {
                try
                {
                    client.Close();
                }
                catch (Exception)
                {
                    // Ignore exception while closing client
                }
            }
            this.Cursor = Cursors.Default;
        }

        private void SinglePatientParticipationButton_Click(object sender, EventArgs e)
        {
            ConsentServiceMessagesTextBox.Visible = false;
            ConsentServiceMessagesTextBox.Text = "";

            this.Cursor = Cursors.WaitCursor;
            ConsentServiceClient client = GetConsentServiceClient();
            try
            {
                string hospitalCode = GetSelectedPatientHospitalCode();
                string codingSystem = GetHospitalCodeSystem();
                string mrn = GetSelectedPatientMrn();
                UserDetails user = GetUser();

                PatientParticipationResponse response = client.GetPatientParticipationStatus(new Mrn(mrn, hospitalCode, codingSystem), user);

                SinglePatientParticipationErrorIndicatorTextBox.Text = response.Response.ToString();
                PatientParticipationGridView.DataSource = response.PatientParticipationList;
                PatientParticipationGridView.Columns["ExtensionData"].Visible = false;
            }
            catch (Exception ex)
            {
                ShowException(ex, ConsentServiceMessagesTextBox);
            }
            finally
            {
                try
                {
                    client.Close();
                }
                catch (Exception)
                {
                    // Ignore exception while closing client
                }
            }
            this.Cursor = Cursors.Default;
        }

        private void GrantConsentRadioButton_CheckedChanged(object sender, EventArgs e)
        {
            ClearResults();
            ConsentConsentTextBox.Text = "false";
            RecordConsentButton.Enabled = true;
            RecordPcehrDisclosureButton.Enabled = false;
            RecordConsentParametersGroupBox.Text = "Required Data for Record Consent Web Service Call";
            ConsentAdmissionDateLabel.Visible = true;
            ConsentAdmissionDateTextBox.Visible = true;
            ConsentLabel.Text = "Consent Withdrawn:";
        }

        private void WithdrawConsentRadioButton_CheckedChanged(object sender, EventArgs e)
        {
            ClearResults();
            ConsentConsentTextBox.Text = "true";
            RecordConsentButton.Enabled = true;
            RecordPcehrDisclosureButton.Enabled = false;
            RecordConsentParametersGroupBox.Text = "Required Data for Record Consent Web Service Call";
            ConsentAdmissionDateLabel.Visible = true;
            ConsentAdmissionDateTextBox.Visible = true;
            ConsentLabel.Text = "Consent Withdrawn:";
        }

        private void RemoveButton_Click(object sender, EventArgs e)
        {
            DateTime submittedTime = DateTime.Now.AddSeconds(-4);
            RemoveServiceMessagesTextBox.Visible = false;
            RemoveServiceMessagesTextBox.Text = "";

            this.Cursor = Cursors.WaitCursor;
            PCEHRServiceClient client = GetPcehrServiceClient();
            try
            {
                string hospitalCode = GetSelectedPatientHospitalCode();
                string codingSystem = GetHospitalCodeSystem();
                string mrn = GetSelectedPatientMrn();
                DateTime admissionDate = SelectedEpisode.AdmissionDate;
                UserDetails user = GetUser();
                RemovalReason reason = (RemovalReason) RemoveReasonComboBox.SelectedItem;
                string documentSetId = RemoveDocumentComboBox.SelectedValue as string;

                HipsResponse response = client.Remove(new Mrn(mrn, hospitalCode, codingSystem), admissionDate, documentSetId, reason, user);

                RemoveErrorIndicatorTextBox.Text = response.ToString();

                SetAuditResults(submittedTime);
            }
            catch (Exception ex)
            {
                ShowException(ex, RemoveServiceMessagesTextBox);
            }
            finally
            {
                try
                {
                    client.Close();
                }
                catch (Exception)
                {
                    // Ignore exception while closing client
                }
            }
            this.Cursor = Cursors.Default;
        }

        private void RemoveReasonComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            ClearResults();
            RemoveReasonTextBox.Text = RemoveReasonComboBox.Text;
        }

        private void RemoveDocumentComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            ClearResults();
            RemoveSetIdTextBox.Text = RemoveDocumentComboBox.SelectedValue as string;
        }

        private void RemoveEpisodeComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            ClearResults();
            string admissionDate = string.Format("{0:dd/MM/yyyy HH:mm:ss}", SelectedEpisode.AdmissionDate);
            RemoveAdmissionDateTextBox.Text = admissionDate;
            RemoveHospitalCodeTextBox.Text = GetSelectedPatientHospitalCode();
            RemoveMrnTextBox.Text = GetSelectedPatientMrn();

            this.documents = null;
            RemoveDocumentComboBox.Text = "";
            RemoveDocumentComboBox.DataSource = Documents;
            RemoveDocumentComboBox.DisplayMember = "SourceSystemSetId";
            RemoveDocumentComboBox.ValueMember = "SourceSystemSetId";

            RemoveButton.Enabled = documents.Count > 0;
        }

        private void RemovePatientComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            ClearResults();
            RemoveHospitalCodeTextBox.Text = GetSelectedPatientHospitalCode();
            RemoveMrnTextBox.Text = GetSelectedPatientMrn();
            RemoveHospitalCodeSystemTextBox.Text = GetHospitalCodeSystem();

            this.episodes = null;
            RemoveEpisodeComboBox.Text = "";
            RemoveDocumentComboBox.Text = "";
            RemoveDocumentComboBox.DataSource = null;
            RemoveEpisodeComboBox.DataSource = Episodes;
            RemoveEpisodeComboBox.DisplayMember = "AdmissionDate";
            RemoveEpisodeComboBox.ValueMember = "AdmissionDate";

            RemoveButton.Enabled = Documents.Count > 0;
        }

        private void UploadRemoveAttachmentButton_Click(object sender, EventArgs e)
        {
            if (attachmentBindingSource.Current != null)
            {
                attachmentBindingSource.RemoveCurrent();
            }
        }

        private void UploadPcehrAuditGridView_CellClick(object sender, DataGridViewCellEventArgs e)
        {
            AnyAuditDataGridViewClick(sender, e);
        }

        private void RemovePcehrAuditGridView_CellClick(object sender, DataGridViewCellEventArgs e)
        {
            AnyAuditDataGridViewClick(sender, e);
        }


        private void RecordPcehrDisclosureButton_Click_1(object sender, EventArgs e)
        {
            ConsentServiceMessagesTextBox.Visible = false;
            ConsentServiceMessagesTextBox.Text = "";

            this.Cursor = Cursors.WaitCursor;
            ConsentServiceClient client = GetConsentServiceClient();
            try
            {
                string hospitalCode = GetSelectedPatientHospitalCode();
                string codingSystem = GetHospitalCodeSystem();
                string mrn = GetSelectedPatientMrn();
                bool disclosed = DisclosePcehrRadioButton.Checked;
                UserDetails user = GetUser();

                HipsResponse response = client.RecordDisclosure(disclosed, new Mrn(mrn, hospitalCode, codingSystem), user, null);

                ConsentErrorIndicatorTextBox.Text = response.ToString();
            }
            catch (Exception ex)
            {
                ShowException(ex, ConsentServiceMessagesTextBox);
            }
            finally
            {
                try
                {
                    client.Close();
                }
                catch (Exception)
                {
                    // Ignore exception while closing client
                }
            }
            this.Cursor = Cursors.Default;
        }

        private void DisclosePcehrRadioButton_CheckedChanged(object sender, EventArgs e)
        {
            ClearResults();
            ConsentConsentTextBox.Text = "true";
            RecordConsentButton.Enabled = false;
            RecordPcehrDisclosureButton.Enabled = true;
            RecordConsentParametersGroupBox.Text = "Required Data for Record Disclosure Web Service Call";
            ConsentAdmissionDateLabel.Visible = false;
            ConsentAdmissionDateTextBox.Visible = false;
            ConsentLabel.Text = "PCEHR Disclosed:";
        }

        private void UndoDisclosureRadioButton_CheckedChanged(object sender, EventArgs e)
        {
            ClearResults();
            ConsentConsentTextBox.Text = "false";
            RecordConsentButton.Enabled = false;
            RecordPcehrDisclosureButton.Enabled = true;
            RecordConsentParametersGroupBox.Text = "Required Data for Record Disclosure Web Service Call";
            ConsentAdmissionDateLabel.Visible = false;
            ConsentAdmissionDateTextBox.Visible = false;
            ConsentLabel.Text = "PCEHR Disclosed:";
        }

        private void environmentComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            DatabaseLoaderServiceClient client = GetDatabaseLoaderServiceClient();
            this.Text = "HIPS Demo Harness - " + client.Endpoint.Address.Uri.Host;
        }

        private DateTime submittedTime;

        private void UploadGetAuditsButton_Click(object sender, EventArgs e)
        {
            SetAuditResults(submittedTime);
        }

        private void UploadQueueGridView_CellContentClick(object sender, DataGridViewCellEventArgs e)
        {
            AnyAuditDataGridViewClick(sender, e);
        }

        private void inputBox_KeyPress(object sender, KeyPressEventArgs e)
        {
            // code for Ctrl-A is 1
            if (e.KeyChar == 1)
            {
                inputBox.SelectAll();
            }
        }


        private void addEpisodeButton_Click(object sender, EventArgs e)
        {
            inputBox.AppendText(Resource.HL7EpisodeSegments);
        }

        private void GainAccessPatientComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            //get patient
            GainAccessButton.Enabled = false;
            string hospitalCode = GetSelectedPatientHospitalCode();
            string codingSystem = GetHospitalCodeSystem();
            string mrn = GetSelectedPatientMrn();
            ClearResults();
            GainAccessHospitalCodeReadOnlyTextBox.Text = GetSelectedPatientHospitalCode();
            GainAccessMrnReadOnlyTextBox.Text = GetSelectedPatientMrn();
            GainAccessDateOfBirthReadOnlyTextBox.Text = string.Format("{0:dd/MM/yyyy}", SelectedPatient.DateOfBirth);
            GainAccessHospitalCodeSystemReadOnlyTextBox.Text = GetHospitalCodeSystem();

        }

        private void GainAccessPopulateIHI_Click(object sender, EventArgs e)
        {
            this.Cursor = Cursors.WaitCursor;

            //get PCEHRStatus
            GainAccessMessagesTextBox.Visible = false;
            GainAccessMessagesTextBox.Text = "";
            GainAccessIHITextBox.Text = "";
            GainAccessIHIStatusTextBox.Text = "";
            GainAccessIHIRecordStatusTextBox.Text = "";
            GainAccessPermissionTextBox.Text = "";
            PCEHRServiceClient client = GetPcehrServiceClient();
            try
            {
                string hospitalCode = GetSelectedPatientHospitalCode();
                string codingSystem = GetHospitalCodeSystem();
                string mrn = GetSelectedPatientMrn();
                DateTime dateOfBirth = GetSelectedPatientDateOfBirth();

                DoesPcehrExistResponse response = client.IsPcehrAdvertised(new Mrn(mrn, hospitalCode, GetHospitalCodeSystem()), dateOfBirth, GetUser());
                GainAccessPcehrReturnStatusTextBox.Text = response.HipsResponse.ToString();

                if (response.PcehrExists.HasValue)
                {
                    GainAccessAdvertisedStatusTextBox.Text = response.PcehrExists.Value ? "Yes, an advertised PCEHR exists." : "No PCEHR exists, or the owner has chosen not to advertise its existence.";
                }
                else
                {
                    GainAccessAdvertisedStatusTextBox.Text = "Unknown";
                }
                switch (response.AccessCodeRequired)
                {
                    case AccessCodeRequired.Unknown:
                        GainAccessPcehrAccessStatusTextBox.Text = "Unknown";
                        break;
                    case AccessCodeRequired.AccessGranted:
                        GainAccessPcehrAccessStatusTextBox.Text = "Your organisation has already gained access to this PCEHR.";
                        break;
                    case AccessCodeRequired.WithCode:
                        GainAccessPcehrAccessStatusTextBox.Text = "Access to this PCEHR is restricted. You can gain access with the code or assert emergency access.";
                        break;
                    case AccessCodeRequired.WithoutCode:
                        GainAccessPcehrAccessStatusTextBox.Text = "Access to this PCEHR is not restricted. You can gain access without a code.";
                        break;
                }
                GainAccessButton.Enabled = true;
            }
            catch (Exception ex)
            {
                ShowException(ex, GainAccessMessagesTextBox);
            }
            finally
            {
                try
                {
                    client.Close();
                }
                catch (Exception)
                {
                    // Ignore exception while closing client
                }
            }

            this.Cursor = Cursors.Default;

           
        }

        private void AccessWithCodeRadioButton_CheckedChanged(object sender, EventArgs e)
        {
            if (((RadioButton)sender).Checked)
            {
                AccessCodeTextBox.Enabled = true;
            }
            else
            {
                AccessCodeTextBox.Enabled = false;
            }
        }

        private void GainAccessButton_Click(object sender, EventArgs e)
        {
            this.Cursor = Cursors.WaitCursor;
            GainAccessMessagesTextBox.Visible = false;
            GainAccessMessagesTextBox.Text = "";
            GainAccessIHITextBox.Text = "";
            GainAccessIHIStatusTextBox.Text = "";
            GainAccessIHIRecordStatusTextBox.Text = "";
            GainAccessPermissionTextBox.Text = "";
            PCEHRServiceClient client = GetPcehrServiceClient();
            try
            {
                string hospitalCode = GetSelectedPatientHospitalCode();
                string codingSystem = GetHospitalCodeSystem();
                string mrn = GetSelectedPatientMrn();
                DateTime dateOfBirth = GetSelectedPatientDateOfBirth();

                GainPcehrAccessResponse gainAccessResponse = new GainPcehrAccessResponse();

                if (AccessWithCodeRadioButton.Checked)
                {
                    gainAccessResponse = client.GainAccessWithCode(new Mrn(mrn, hospitalCode, GetHospitalCodeSystem()), AccessCodeTextBox.Text, GetUser());
                }
                else if (AccessWithOutCodeRadioButton.Checked)
                {
                    gainAccessResponse = client.GainAccessWithOutCode(new Mrn(mrn, hospitalCode, GetHospitalCodeSystem()), GetUser());
                }
                else if (EmergencyAccessRadioButton.Checked)
                {
                    gainAccessResponse = client.GainAccessEmergency(new Mrn(mrn, hospitalCode, GetHospitalCodeSystem()), GetUser());                
                }

                GainAccessIHITextBox.Text = gainAccessResponse.IHINumber;
                GainAccessIHIStatusTextBox.Text = gainAccessResponse.IhiStatus.ToString();
                GainAccessIHIRecordStatusTextBox.Text = gainAccessResponse.IhiRecordStatus.ToString();
                GainAccessPermissionTextBox.Text = gainAccessResponse.AccessPermission.ToString();
                
                StringBuilder message = new StringBuilder();
                message.AppendLine("Status:" + gainAccessResponse.HipsResponse.Status);

                if (gainAccessResponse.HipsResponse.Status != HipsResponseIndicator.OK) 
                {
                    message.AppendLine("ResponseCode:" + gainAccessResponse.HipsResponse.ResponseCode);
                    message.AppendLine("ResponseCodeDescription:" + gainAccessResponse.HipsResponse.ResponseCodeDescription);
                    message.AppendLine("ResponseCodeDetails:" + gainAccessResponse.HipsResponse.ResponseCodeDetails);
                    message.AppendLine("HipsErrorMessage:" + gainAccessResponse.HipsResponse.HipsErrorMessage);
                }
                GainAccessMessagesTextBox.Text = message.ToString();
                GainAccessMessagesTextBox.Visible = true;
            }
            catch (Exception ex)
            {
                ShowException(ex, GainAccessMessagesTextBox);
            }
            finally
            {
                try
                {
                    client.Close();
                }
                catch (Exception)
                {
                    // Ignore exception while closing client
                }
            }
            this.Cursor = Cursors.Default;
        }

        private void CreationStartDateCheckBox_CheckedChanged(object sender, EventArgs e)
        {
            if (((CheckBox)sender).Checked)
            {
                CreationStartDateTimePicker.Enabled = true;
            }
            else
            {
                CreationStartDateTimePicker.Enabled = false;
            }
        }

        private void CreationEndDateCheckBox_CheckedChanged(object sender, EventArgs e)
        {
            if (((CheckBox)sender).Checked)
            {
                CreationEndDateTimePicker.Enabled = true;
            }
            else
            {
                CreationEndDateTimePicker.Enabled = false;
            }
        }

        private void ServiceStartDateCheckBox_CheckedChanged(object sender, EventArgs e)
        {
            if (((CheckBox)sender).Checked)
            {
                ServiceStartDateTimePicker.Enabled = true;
            }
            else
            {
                ServiceStartDateTimePicker.Enabled = false;
            }
        }

        private void ServiceEndDateCheckBox_CheckedChanged(object sender, EventArgs e)
        {
            if (((CheckBox)sender).Checked)
            {
                ServiceEndDateTimePicker.Enabled = true;
            }
            else
            {
                ServiceEndDateTimePicker.Enabled = false;
            }
        }

        private void DocListPatientComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            //get patient
            string hospitalCode = GetSelectedPatientHospitalCode();
            string codingSystem = GetHospitalCodeSystem();
            string mrn = GetSelectedPatientMrn();
            ClearResults();
            DocListHospitalCodeReadOnlyTextBox.Text = GetSelectedPatientHospitalCode();
            DocListMrnReadOnlyTextBox.Text = GetSelectedPatientMrn();
            DocListDateOfBirthReadOnlyTextBox.Text = string.Format("{0:dd/MM/yyyy}", SelectedPatient.DateOfBirth);
            DocListHospitalCodeSystemReadOnlyTextBox.Text = GetHospitalCodeSystem();
            GetDocListButton.Enabled = true;
        }

        private void GetDocListButton_Click(object sender, EventArgs e)
        {
            this.Cursor = Cursors.WaitCursor;
            DocListMessagesTextBox.Visible = false;
            DocListMessagesTextBox.Text = "";

            bool active = false;
            IList<DocumentStatus> statusList = new List<DocumentStatus>();
            if (DocListStatus.SelectedIndices.Count > 0)
            {
                foreach (String item in DocListStatus.SelectedItems)
                {
                    switch ((DocumentStatus)Enum.Parse(typeof(DocumentStatus), item, true)) 
                    {
                        case DocumentStatus.Approved:
                            statusList.Add(DocumentStatus.Approved);
                            active = true;
                            break;
                        case DocumentStatus.Deleted:
                            statusList.Add(DocumentStatus.Deleted);
                            break;
                        case DocumentStatus.Deprecated:
                            statusList.Add(DocumentStatus.Deprecated);
                            break;
                        case DocumentStatus.Submitted:
                            statusList.Add(DocumentStatus.Submitted);
                            break;
                    }
                }
            }
                
            PCEHRServiceClient client = GetPcehrServiceClient();
            try
            {
                string hospitalCode = GetSelectedPatientHospitalCode();
                string codingSystem = GetHospitalCodeSystem();
                string mrn = GetSelectedPatientMrn();
                DateTime dateOfBirth = GetSelectedPatientDateOfBirth();

                DocumentListResponse documentListResponseResponse = new DocumentListResponse();

                if (CreationStartDateCheckBox.Checked || CreationEndDateCheckBox.Checked
                || ServiceStartDateCheckBox.Checked || ServiceEndDateCheckBox.Checked)
                {
                    DateTime? creationStartDate = null;
                    DateTime? creationEndDate = null;
                    DateTime? serviceStartDate = null;
                    DateTime? serviceEndDate = null;
                    
                    if (CreationStartDateCheckBox.Checked)
                    {
                        creationStartDate = CreationStartDateTimePicker.Value;
                    }
                    if (CreationEndDateCheckBox.Checked)
                    {
                        creationEndDate = CreationEndDateTimePicker.Value;
                    }
                    if (ServiceStartDateCheckBox.Checked)
                    {
                        serviceStartDate = ServiceStartDateTimePicker.Value;  
                    }
                    if (ServiceEndDateCheckBox.Checked)
                    {
                        serviceEndDate = ServiceEndDateTimePicker.Value;
                    }

                    if (statusList.Count == 0)
                    {
                        //GetDocumentListFilterDates
                        documentListResponseResponse = client.GetDocumentListFilterDates(new Mrn(mrn, hospitalCode, GetHospitalCodeSystem()), GetUser(), creationStartDate, creationEndDate, serviceStartDate, serviceEndDate);
                    }
                    else
                    {
                        if (active)
                        {
                            //GetDocumentListActiveFilterDates
                            documentListResponseResponse = client.GetDocumentListFilterDates(new Mrn(mrn, hospitalCode, GetHospitalCodeSystem()), GetUser(), creationStartDate, creationEndDate, serviceStartDate, serviceEndDate);

                        }
                        else
                        {
                            //GetDocumentListFilterStatusAndDates
                            //(all except active)
                            documentListResponseResponse = client.GetDocumentListFilterStatusAndDates(new Mrn(mrn, hospitalCode, GetHospitalCodeSystem()), GetUser(), statusList.ToArray<DocumentStatus>(), creationStartDate, creationEndDate, serviceStartDate, serviceEndDate);
                        }
                    }
                }
                else //no dates
                {
                    if (statusList.Count == 0)
                    {
                        //GetDocumentList
                        documentListResponseResponse = client.GetDocumentList(new Mrn(mrn, hospitalCode, GetHospitalCodeSystem()), GetUser());
                    }
                    else
                    {
                        if (active)
                        {
                            //GetDocumentListActive
                            documentListResponseResponse = client.GetDocumentListActive(new Mrn(mrn, hospitalCode, GetHospitalCodeSystem()), GetUser());
                        }
                        else
                        {
                            //GetDocument List with other statuses besides active - tests base docQuery also
                            DocumentQuery docQuery = new DocumentQuery();
                            docQuery.DocumentStatus = statusList.ToArray<DocumentStatus>();
                            documentListResponseResponse = client.GetDocumentListWithQuery(new Mrn(mrn, hospitalCode, GetHospitalCodeSystem()), GetUser(), docQuery);
                        }
                    }

                }

                DocumentListGridView.DataSource = documentListResponseResponse.DocumentList;
                DocumentListGridView.Columns["ExtensionData"].Visible = false;

                StringBuilder message = new StringBuilder();
                message.AppendLine("Status:" + documentListResponseResponse.HipsResponse.Status);

                if (documentListResponseResponse.HipsResponse.Status != HipsResponseIndicator.OK)
                {
                    message.AppendLine("ResponseCode:" + documentListResponseResponse.HipsResponse.ResponseCode);
                    message.AppendLine("ResponseCodeDescription:" + documentListResponseResponse.HipsResponse.ResponseCodeDescription);
                    message.AppendLine("ResponseCodeDetails:" + documentListResponseResponse.HipsResponse.ResponseCodeDetails);
                    message.AppendLine("HipsErrorMessage:" + documentListResponseResponse.HipsResponse.HipsErrorMessage);
                }
                DocListMessagesTextBox.Text = message.ToString();
                DocListMessagesTextBox.Visible = true;
            }
            catch (Exception ex)
            {
                ShowException(ex, DocListMessagesTextBox);
            }
            finally
            {
                try
                {
                    client.Close();
                }
                catch (Exception)
                {
                    // Ignore exception while closing client
                }
            }
            this.Cursor = Cursors.Default;

        }

        private void DocumentListGridView_CellContentClick(object sender, DataGridViewCellEventArgs e)
        {
            if (e.RowIndex < 0 || (e.ColumnIndex != DocumentListGridView.Columns["ChangeHistoryColumnButton"].Index 
                                        && e.ColumnIndex != DocumentListGridView.Columns["OpenDocColumnButton"].Index))
            {
                return;
            }
            //String documentUniqueId  = ((DataGridView)sender).CurrentRow.Cells["DocumentUniqueId"].Value.ToString();
            //String RepositoryUniqueId = ((DataGridView)sender).CurrentRow.Cells["RepositoryUniqueId"].Value.ToString();

            String documentUniqueId  = DocumentListGridView.Rows[e.RowIndex].Cells["DocumentUniqueId"].Value.ToString();
            String repositoryUniqueId = DocumentListGridView.Rows[e.RowIndex].Cells["RepositoryUniqueId"].Value.ToString();

            if (e.ColumnIndex == DocumentListGridView.Columns["ChangeHistoryColumnButton"].Index)
            {
                ChangeHistoryDocumentUniqueIdTextBox.Text = documentUniqueId;
                HipsTestHarnessTabControl.SelectedTab = ChangeHistoryPage;
            }
            else if (e.ColumnIndex == DocumentListGridView.Columns["OpenDocColumnButton"].Index)
            {
                DownloadDocDocumentUniqueIdTextBox.Text = documentUniqueId;
                DownloadDocRepositoryUniqueIdTextBox.Text = repositoryUniqueId;
                HipsTestHarnessTabControl.SelectedTab = DownloadDocumentPage;
            }

        }

        private void ChangeHistoryButton_Click(object sender, EventArgs e)
        {
            this.Cursor = Cursors.WaitCursor;
            ChangeHistoryMessagesTextBox.Visible = false;
            ChangeHistoryMessagesTextBox.Text = "";
            PCEHRServiceClient client = GetPcehrServiceClient();
            try
            {
                string hospitalCode = GetSelectedPatientHospitalCode();
                string codingSystem = GetHospitalCodeSystem();
                string mrn = GetSelectedPatientMrn();
                DateTime dateOfBirth = GetSelectedPatientDateOfBirth();

                ChangeHistoryViewResponse changeHistoryViewResponse = new ChangeHistoryViewResponse();

                changeHistoryViewResponse = client.GetChangeHistoryView(new Mrn(mrn, hospitalCode, GetHospitalCodeSystem()), GetUser(), ChangeHistoryDocumentUniqueIdTextBox.Text);
                ChangeHistoryGridView.DataSource = changeHistoryViewResponse.DocumentList;
                ChangeHistoryGridView.Columns["ExtensionData"].Visible = false;

                StringBuilder message = new StringBuilder();
                message.AppendLine("Status:" + changeHistoryViewResponse.HipsResponse.Status);

                if (changeHistoryViewResponse.HipsResponse.Status != HipsResponseIndicator.OK)
                {
                    message.AppendLine("ResponseCode:" + changeHistoryViewResponse.HipsResponse.ResponseCode);
                    message.AppendLine("ResponseCodeDescription:" + changeHistoryViewResponse.HipsResponse.ResponseCodeDescription);
                    message.AppendLine("ResponseCodeDetails:" + changeHistoryViewResponse.HipsResponse.ResponseCodeDetails);
                    message.AppendLine("HipsErrorMessage:" + changeHistoryViewResponse.HipsResponse.HipsErrorMessage);
                }
                ChangeHistoryMessagesTextBox.Text = message.ToString();
                ChangeHistoryMessagesTextBox.Visible = true;
            }
            catch (Exception ex)
            {
                ShowException(ex, ChangeHistoryMessagesTextBox);
            }
            finally
            {
                try
                {
                    client.Close();
                }
                catch (Exception)
                {
                    // Ignore exception while closing client
                }
            }
            this.Cursor = Cursors.Default;
        }

        private void ChangeHistoryPatientComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            //get patient
            string hospitalCode = GetSelectedPatientHospitalCode();
            string codingSystem = GetHospitalCodeSystem();
            string mrn = GetSelectedPatientMrn();
            ClearResults();
            ChangeHistoryHospitalCodeReadOnlyTextBox.Text = GetSelectedPatientHospitalCode();
            ChangeHistoryMrnReadOnlyTextBox.Text = GetSelectedPatientMrn();
            ChangeHistoryDateOfBirthReadOnlyTextBox.Text = string.Format("{0:dd/MM/yyyy}", SelectedPatient.DateOfBirth);
            ChangeHistoryHospitalCodeSystemReadOnlyTextBox.Text = GetHospitalCodeSystem();
            ChangeHistoryButton.Enabled = true;
        }

        private void DownloadDocPatientComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            //get patient
            string hospitalCode = GetSelectedPatientHospitalCode();
            string codingSystem = GetHospitalCodeSystem();
            string mrn = GetSelectedPatientMrn();
            ClearResults();
            DownloadDocHospitalCodeReadOnlyTextBox.Text = GetSelectedPatientHospitalCode();
            DownloadDocMrnReadOnlyTextBox.Text = GetSelectedPatientMrn();
            DownloadDocDateOfBirthReadOnlyTextBox.Text = string.Format("{0:dd/MM/yyyy}", SelectedPatient.DateOfBirth);
            DownloadDocHospitalCodeSystemReadOnlyTextBox.Text = GetHospitalCodeSystem();
            DownloadDocumentButton.Enabled = true;
        }

        private void DownloadDocumentButton_Click(object sender, EventArgs e)
        {
            this.Cursor = Cursors.WaitCursor;
            DownloadDocMessagesTextBox.Visible = false;
            DownloadDocMessagesTextBox.Text = "";
            AttachmentListBox.Items.Clear();
            PCEHRServiceClient client = GetPcehrServiceClient();
            StringBuilder message = new StringBuilder();
            try
            {
                string hospitalCode = GetSelectedPatientHospitalCode();
                string codingSystem = GetHospitalCodeSystem();
                string mrn = GetSelectedPatientMrn();
                DateTime dateOfBirth = GetSelectedPatientDateOfBirth();

                DocumentResponse documentResponse = new DocumentResponse();
                DocumentRequest documentRequest = new DocumentRequest();
                
                documentRequest.DocumentUniqueId = DownloadDocDocumentUniqueIdTextBox.Text;
                documentRequest.RepositoryUniqueId = DownloadDocRepositoryUniqueIdTextBox.Text;

                documentResponse = client.RetrieveDocument(new Mrn(mrn, hospitalCode, GetHospitalCodeSystem()), GetUser(), documentRequest);

                if (documentResponse.FileName != null) { 
                    DownloadDocRootFileName.Text = documentResponse.FileName;

                    try
                    {
                        if (!Directory.Exists(DownloadDocSavePath.Text))
                        {
                            System.IO.Directory.CreateDirectory(DownloadDocSavePath.Text);
                        }

                        FileStream stream = new FileStream(Path.Combine(DownloadDocSavePath.Text, documentResponse.FileName), FileMode.Create, FileAccess.Write);
                        stream.Write(documentResponse.Document, 0, documentResponse.Document.Length);
                        stream.Close();
                    }
                    catch (Exception fioe)
                    {
                        message.AppendLine("Error Writing Root File:" + documentResponse.FileName);
                        message.AppendLine(fioe.ToString());
                    }

                    if (documentResponse.Attachments.Count() != 0)
                    {
                        foreach (HIPS.PcehrSchemas.Attachment attact in documentResponse.Attachments)
                        {
                            AttachmentListBox.Items.Add(attact.FileName);
                            try
                            {
                                FileStream stream = new FileStream(Path.Combine(DownloadDocSavePath.Text, attact.FileName), FileMode.Create, FileAccess.Write);
                                stream.Write(attact.Contents, 0, attact.Contents.Length);
                                stream.Close();
                            }
                            catch (Exception fioe)
                            {
                                message.AppendLine("Error Writing Attachment File: " + attact.FileName);
                                message.AppendLine(attact.FileName + fioe.ToString());
                            }
                        }
                    }
                }
                message.AppendLine("Status:" + documentResponse.HipsResponse.Status);

                if (documentResponse.HipsResponse.Status != HipsResponseIndicator.OK)
                {
                    message.AppendLine("ResponseCode:" + documentResponse.HipsResponse.ResponseCode);
                    message.AppendLine("ResponseCodeDescription:" + documentResponse.HipsResponse.ResponseCodeDescription);
                    message.AppendLine("ResponseCodeDetails:" + documentResponse.HipsResponse.ResponseCodeDetails);
                    message.AppendLine("HipsErrorMessage:" + documentResponse.HipsResponse.HipsErrorMessage);
                }
                DownloadDocMessagesTextBox.Text = message.ToString();
                DownloadDocMessagesTextBox.Visible = true;
            }
            catch (Exception ex)
            {
                ShowException(ex, DownloadDocMessagesTextBox);
            }
            finally
            {
                try
                {
                    client.Close();
                }
                catch (Exception)
                {
                    // Ignore exception while closing client
                }
            }
            this.Cursor = Cursors.Default;
        }

        private void OpenExplorerFolderButton_Click(object sender, EventArgs e)
        {
            DownloadDocMessagesTextBox.Text = "";
            DownloadDocMessagesTextBox.Visible = false;
            if (Directory.Exists(DownloadDocSavePath.Text))
            {
                Process.Start("explorer.exe", DownloadDocSavePath.Text);
            }
            else
            {
                StringBuilder message = new StringBuilder();
                message.AppendLine("'" + DownloadDocSavePath.Text + "' is not a valid path.");
                DownloadDocMessagesTextBox.Text = message.ToString();
                DownloadDocMessagesTextBox.Visible = true;
            }
        }

        private void ViewDocumentButton_Click(object sender, EventArgs e)
        {
            if (DownloadDocRootFileName.Text != string.Empty)
            {
                using (Stream strm = Assembly.GetExecutingAssembly().GetManifestResourceStream("HIPS.DemoHarness.Xslt.NEHTA_Generic_CDA_Stylesheet-1.2.7.xsl"))
                {
                    using (XmlReader reader = XmlReader.Create(strm))
                    {
                        XslCompiledTransform xslt = new XslCompiledTransform();
                        xslt.Load(reader);
                        // use the XslTransform object

                        string xmlFilename = (DownloadDocSavePath.Text + Path.AltDirectorySeparatorChar + DownloadDocRootFileName.Text).ToLower();
                        string htmlFilename = xmlFilename.Replace(".xml", ".html");

                        if (File.Exists(xmlFilename))
                        {

                            XmlDocument xml = new XmlDocument();
                            xml.Load(xmlFilename);

                            FileStream html = new FileStream(htmlFilename, FileMode.Create);

                            xslt.Transform(xml, null, html);

                            html.Close();

                            ViewDocumentForm viewDoc = new ViewDocumentForm(htmlFilename);
                            viewDoc.ShowDialog();
                        }
                    }
                }
            }
        }

        private void button1_Click(object sender, EventArgs e)
        {

            HpiiProxy proxy = new HpiiProxy("HpiiSearchEndPoint");
            HpiiIdentifierQuery hpiiIdentifierQuery = new HpiiIdentifierQuery();
            UserDetails user = new UserDetails();

            hpiiIdentifierQuery.FamilyName = "JONES";
            hpiiIdentifierQuery.HpioNumber = "8003623233353555";
            //hpiiIdentifierQuery.OnlyNameIndicator = false;
            hpiiIdentifierQuery.Sex = SexType.F;
            hpiiIdentifierQuery.HpiiNumber = "8003615833334118";
            hpiiIdentifierQuery.PostCode = "";

            user.Role = UserRole.AuthorisedEmployee;
            //user.IsContractedServiceProvider = false;

            HiCountry country = new HiCountry();
            country.Description = "ok";

            HpiiQueryResponse response = proxy.HpiiValidation(hpiiIdentifierQuery, user);
           

        }
    }
}
