﻿using System;
using System.Diagnostics;
using System.ServiceProcess;

namespace HIPS.AppServer.HIPSServiceHost.BackgroundThread
{
    public class IhiCleanUpService : ServiceBase
    {
        private HIPS.AppServer.HIPSServiceHost.BackgroundThread.IhiCleanUpServiceHost IhiCleanUpServiceHostObj = null;

        public IhiCleanUpService()
        {
        }

        protected override void OnStart(string[] args)
        {
            Debug.WriteLine(String.Format("{0} - Starting IhiCleanUpService", DateTime.Now.ToString()));

            // Start Ihi Clean Up Service.
            IhiCleanUpServiceHostObj = new IhiCleanUpServiceHost(typeof(IhiCleanUpService));
            IhiCleanUpServiceHostObj.Open();
        }

        protected override void OnStop()
        {
            if (IhiCleanUpServiceHostObj != null)
            {
                IhiCleanUpServiceHostObj.Close();
                IhiCleanUpServiceHostObj = null;
            }
        }
    }
}