﻿using System.Threading;

namespace HIPS.AppServer.HIPSServiceHost.BackgroundThread
{
    /// <summary>
    /// Used by the Timer in the IhiCleanupServiceHost to contain state information within the callback.
    /// The Timer reference is used to allow the callback method to change the period of the timer.
    /// </summary>
    public class TimerState
    {
        /// <summary>
        /// Whether the state object is initialised (the Timer reference is up-to-date).
        /// The state object is passed to the timer constructor without the timer reference (obviously).
        /// The state object may not be valid until it has been initialised.
        /// </summary>
        public bool isInitialised;

        /// <summary>
        /// Whether the timer is waiting for 5 minutes.
        /// </summary>
        public bool isWaiting;

        /// <summary>
        /// The reference to the Timer object.
        /// </summary>
        public Timer timer;

        /// <summary>
        /// Updates the timer and initialises the object.
        /// </summary>
        /// <param name="timer"></param>
        public void SetTimerReference(Timer timer)
        {
            this.timer = timer;
            this.isInitialised = true;
        }

        /// <summary>
        /// Updates the frequency of the timer, and specifies if the timer is waiting.
        /// </summary>
        /// <param name="period">The delay in milliseconds.</param>
        /// <param name="isWaiting"></param>
        public void UpdateTimerFrequency(int period, bool isWaiting)
        {
            this.timer.Change(period, 5000);
            this.isWaiting = isWaiting;
        }
    }
}