﻿using System.Collections.Generic;
using HIPS.PcehrDataStore.Schemas;
using HIPS.PcehrDataStore.Schemas.Schemas;

namespace HIPS.BusinessEntities.ResponseEntities
{
    /// <summary>
    /// Represents details of a hospital.
    /// </summary>
    public class HospitalDetailResponse
    {
        /// <summary>
        /// Gets or sets the list of addresses.
        /// </summary>
        public List<Address> Addresses { get; set; }

        /// <summary>
        /// Gets or sets the list of electronic contact details.
        /// </summary>
        public List<Contact> Contacts { get; set; }

        /// <summary>
        /// Gets or sets the full name.
        /// </summary>
        public string FullName { get; set; }

        /// <summary>
        /// Gets or sets the extension that represents this hospital.
        /// </summary>
        public string HospitalIdentifierExtension { get; set; }

        /// <summary>
        /// Gets or sets the root OID for local hospital facility identifiers.
        /// </summary>
        public string HospitalIdentifierRoot { get; set; }

        /// <summary>
        /// Gets or sets the HPI-O.
        /// </summary>
        public string HpiO { get; set; }

        /// <summary>
        /// Gets or sets the root OID for local patient identifiers at the hospital.
        /// </summary>
        public string PatientIdentifierRoot { get; set; }

        /// <summary>
        /// Gets or sets the root OID for local provider identifiers at the hospital.
        /// </summary>
        public string ProviderIdentifierRoot { get; set; }

        /// <summary>
        /// Gets or sets the short description.
        /// </summary>
        public string ShortDescription { get; set; }
    }
}