﻿namespace HIPS.CommonBusinessLogic.Cda
{
    /// <summary>
    /// Enumeration type listing the recognised types of healthcare identifier.
    /// </summary>
    internal enum HiType
    {
        /// <summary>
        /// Represents HPI-I.
        /// </summary>
        HpiI,

        /// <summary>
        /// Represents HPI-O.
        /// </summary>
        HpiO,

        /// <summary>
        /// Represents IHI.
        /// </summary>
        Ihi
    }

    /// <summary>
    /// Represents validation rules that apply to a type of healthcare identifier.
    /// </summary>
    internal class HiValidationParameters
    {
        /// <summary>
        /// Gets or sets the description of the healthcare identifier type.
        /// </summary>
        public string Description { get; set; }

        /// <summary>
        /// Gets or sets the expected first six digits for the healthcare identifier type.
        /// </summary>
        public string FirstSixDigits { get; set; }

        /// <summary>
        /// Gets or sets the type of healthcare identifier.
        /// </summary>
        public HiType Type { get; set; }
    }
}