﻿using System.Collections.Generic;

namespace HIPS.CommonSchemas.Cda
{
    /// <summary>
    /// Common Model for Individual Name.
    /// </summary>
    public class IndividualName
    {
        #region Properties

        /// <summary>
        /// Gets or sets the family name of the individual.
        /// </summary>
        public string FamilyName { get; set; }

        /// <summary>
        /// Gets or sets the given names of the individual, separated by spaces.
        /// </summary>
        public List<string> GivenNames { get; set; }

        /// <summary>
        /// Gets or sets the suffixes of the individual, separated by spaces.
        /// </summary>
        public List<string> Suffixes { get; set; }

        /// <summary>
        /// Gets or sets the titles of the individual, separated by spaces.
        /// </summary>
        public List<string> Titles { get; set; }

        /// <summary>
        /// Gets or sets the name usage.
        /// </summary>
        public IndividualNameUsage Usage { get; set; }

        #endregion Properties

        /// <summary>
        /// Determines whether this name is materially different to the other name.
        /// A material difference is a different family name or different given names,
        /// with a case-insensitive comparison.
        /// </summary>
        /// <param name="other">The other name.</param>
        /// <returns>True if the names differ, or false if they are the same.</returns>
        public bool IsMateriallyDifferentFrom(IndividualName other)
        {
            if (this.FamilyName.ToUpper() != other.FamilyName.ToUpper())
            {
                return true;
            }
            if (string.Join(" ", this.GivenNames).ToUpper() != string.Join(" ", other.GivenNames).ToUpper())
            {
                return true;
            }
            return false;
        }
    }
}