﻿using System;
using System.Collections.Generic;
using System.Runtime.Serialization;
using HIPS.CommonSchemas;

namespace HIPS.PatientSchemas
{
    /// <summary>
    /// This object is used for the packaged response from the Patient List web service interface.
    /// </summary>
    [Serializable]
    [DataContract(Name = "AdmittedPatientListResponse")]
    public class AdmittedPatientListResponse
    {
        #region Private Members

        private HipsResponse hipsResponse = new HipsResponse(HipsResponseIndicator.SystemError, null);
        private IList<AdmittedPatient> patientList = new List<AdmittedPatient>();

        #endregion Private Members

        #region Properties

        /// <summary>
        /// Gets or sets the admitted patient list.
        /// </summary>
        /// <value>
        /// The admitted patient list.
        /// </value>
        [DataMember]
        public IList<AdmittedPatient> AdmittedPatientList
        {
            get { return patientList; }
            set { patientList = value; }
        }

        /// <summary>
        /// Gets or sets the HipsResponse.
        /// Common Response Object.
        /// </summary>
        /// <value>
        /// The hipsResponse
        /// </value>
        [DataMember]
        public HipsResponse HipsResponse
        {
            get { return hipsResponse; }
            set { hipsResponse = value; }
        }

        #endregion Properties
    }
}