﻿using System.Data.SqlClient;
using HIPS.Common.PcehrDataStore.DataAccess;
using HIPS.CommonSchemas;
using HIPS.PcehrDataStore.Schemas;

namespace HIPS.PcehrDataStore.DataAccess
{
    /// <summary>
    /// This class allows access to the HpiiLookupAudit table
    /// </summary>
    public class HpiiLookupAuditDl : BaseDl
    {
        #region Constructors

        public HpiiLookupAuditDl(UserDetails user)
            : base(user)
        {
        }

        #endregion Constructors

        #region Methods

        /// <summary>
        /// Inserts the specified hpii lookup audit.
        /// </summary>
        /// <param name="HpiiLookupAudit">The hpii lookup audit.</param>
        /// <returns></returns>
        public bool Insert(HpiiLookupAudit HpiiLookupAudit)
        {
            using (SqlCommand command = GetSqlCommand("hips.HpiiLookupAuditInsert"))
            {
                return base.Insert<HpiiLookupAudit>(HpiiLookupAudit, command);
            }
        }

        #endregion Methods
    }
}