﻿using System;
using System.Collections.Generic;
using System.Runtime.Serialization;
using HIPS.CommonSchemas;
using HIPS.CommonSchemas.PatientIdentifier;

namespace HIPS.PcehrSchemas
{
    /// <summary>
    /// This object is used to return the local document and possible list of attachments from the local document repository of uploaded documents,
    /// </summary>
    [Serializable]
    [DataContract]
    public class LocalClinicalDocumentResponse<T> where T : PatientIdentifierBase
    {
        #region Private Members

        private IList<Attachment> attachments = new List<Attachment>();
        private byte[] document;
        private HipsResponse hipsResponse = new HipsResponse(HipsResponseIndicator.SystemError, null);
        private LocalClinicalDocumentMetaData localClinicalDocumentMetaData;
        private T patientIdentifier;

        #endregion Private Members

        #region Properties

        /// <summary>
        /// Gets or sets the Attachments
        /// </summary>
        /// <value>
        /// The attachments
        /// </value>
        [DataMember]
        public IList<Attachment> Attachments
        {
            get { return attachments; }
            set { attachments = value; }
        }

        /// <summary>
        /// Gets or sets the Document
        /// </summary>
        /// <value>
        /// The document
        /// </value>
        [DataMember]
        public byte[] Document
        {
            get { return document; }
            set { document = value; }
        }

        /// <summary>
        /// Gets or sets the HipsResponse, which contains information about success, warnings or failure.
        /// </summary>
        /// <value>
        /// The HipsResponse
        /// </value>
        [DataMember]
        public HipsResponse HipsResponse
        {
            get { return hipsResponse; }
            set { hipsResponse = value; }
        }

        /// <summary>
        /// LocalClinicalDocumentMetaData of the document returned
        /// </summary>
        [DataMember]
        public LocalClinicalDocumentMetaData LocalClinicalDocumentMetaData
        {
            get { return localClinicalDocumentMetaData; }
            set { localClinicalDocumentMetaData = value; }
        }

        /// <summary>
        /// Gets or sets the PatientIdentifier.
        /// Patient Identifier Class that matches the same object that was used as the passed in PatientIdentifier Class.
        /// </summary>
        /// <value>
        /// The PatientIdentifier
        /// </value>
        [DataMember]
        public T PatientIdentifier
        {
            get { return patientIdentifier; }
            set { patientIdentifier = value; }
        }

        #endregion Properties
    }
}