﻿using System.Runtime.Serialization;
using HIPS.ServiceContracts.Common;
using HIPS.ServiceContracts.Common.DTO;
using EntLibVal = Microsoft.Practices.EnterpriseLibrary.Validation;
using System;
using System.Collections.Generic;

namespace HIPS.ServiceContracts.Hpii.DTO
{
    /// <summary>
    /// HPI-I Search Result DTO. This object represents a matching provider individual.
    /// </summary>
    [DataContract(Namespace = HIPS.ServiceContracts.Common.Constants.ServiceNamespace.HPII_V2)]
    public class SearchResult
    {
        #region Properties

        /// <summary>
        /// Gets or sets the HPI-I number.
        /// </summary>
        [DataMember(IsRequired = false)]
        [EntLibVal.Validators.StringLengthValidator(16, 16)]
        [EntLibVal.Validators.IgnoreNulls]
        public string HpiiNumber { get; set; }

        /// <summary>
        /// Gets or sets the HPI-I status.
        /// </summary>
        [DataMember(IsRequired = false)]
        public HpiiStatus HpiiStatus { get; set; }

        /// <summary>
        /// Gets or sets the registration ID.
        /// </summary>
        [DataMember(IsRequired = false)]
        [EntLibVal.Validators.IgnoreNulls]
        [EntLibVal.Validators.StringLengthValidator(1, 20)]
        public string RegistrationId { get; set; }

        /// <summary>
        /// Gets or sets the Australian address.
        /// </summary>
        [DataMember(IsRequired = false)]
        [EntLibVal.Validators.IgnoreNulls]
        [EntLibVal.Validators.ObjectValidator]
        public StructuredAustralianAddress AustralianAddress { get; set; }

        /// <summary>
        /// Gets or sets the international address.
        /// </summary>
        [DataMember(IsRequired = false)]
        [EntLibVal.Validators.IgnoreNulls]
        [EntLibVal.Validators.ObjectValidator]
        public InternationalAddress InternationalAddress { get; set; }

        /// <summary>
        /// Gets or sets the family name.
        /// </summary>
        [DataMember(IsRequired = true)]
        [EntLibVal.Validators.StringLengthValidator(1, 40)]
        public string FamilyName { get; set; }

        /// <summary>
        /// Gets or sets the given names.
        /// </summary>
        [DataMember(IsRequired = false)]
        [EntLibVal.Validators.StringLengthValidator(1, 40)]
        public List<string> GivenNames { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether the individual has only one name.
        /// If this field is true, the one name must be provided in the FamilyName 
        /// field and the GivenNames list must be empty.
        /// </summary>
        [DataMember(IsRequired = true)]
        public bool OnlyNameIndicator { get; set; }

        /// <summary>
        /// Gets or sets the Date of Birth.
        /// </summary>
        [DataMember(IsRequired = false)]
        [EntLibVal.Validators.IgnoreNulls]
        [EntLibVal.Validators.DateTimeRangeValidator(Constants.SupportedDates.MINIMUM, Constants.SupportedDates.MAXIMUM)]
        public DateTime? DateOfBirth { get; set; }

        /// <summary>
        /// Gets or sets the sex.
        /// </summary>
        [DataMember(IsRequired = false)]
        public Sex? Sex { get; set; }

        /// <summary>
        /// Gets or sets the Australian postcode.
        /// </summary>
        [DataMember(IsRequired = false)]
        [EntLibVal.Validators.StringLengthValidator(1, 4)]
        [EntLibVal.Validators.IgnoreNulls]
        public string AustralianPostcode { get; set; }

        /// <summary>
        /// Gets or sets the Australian state.
        /// </summary>
        [DataMember(IsRequired = false)]
        public AustralianState AustralianState { get; set; }

        #endregion Properties
    }
}