﻿using Microsoft.VisualStudio.TestTools.UnitTesting;
using Test.CommonCcaNoc.Helpers;

namespace Test.HiCcaNoc.CCA.UC_325
{
    /// <summary>
    /// When the receiving software determines any healthcare identifier in
    /// an incoming eHealth message/document is invalid, the software shall
    /// initiate a negative application-level acknowledgement to the sender
    /// of the eHealth message/document and/or alert an operator.
    /// </summary>
    [TestClass]
    public class HI_CCA_325_016385 : CcaTest
    {
        /// <summary>
        /// The Negative application-level acknowledgements or raises an alert 
        /// when receiving invalid eHealth message/document
        /// 
        /// a. Verify that when the software determines any healthcare identifier
        /// in an incoming eHealth message/document to be invalid then the software
        /// shall initiate a negative application-level acknowledgement to the 
        /// sender of the eHealth message/document OR
        /// 
        /// b. Verify that when the software determines any healthcare identifier
        /// in an incoming eHealth message/document to be invalid then the software
        /// shall raise an alert.
        /// </summary>
        [TestMethod]
        [TestCategory("HI_CCA_325")]
        public void HI_CCA_325_016385_1()
        {
            // TODO: Store a sealed message XML file with an invalid healthcare identifier into C:\Secure Messaging\Sealed Messages\Inbox.

            // TODO: Check that HIPS has produced a negative transport response

            // TODO: Check that HIPS has raised the alert.
        }    
    }
}
