﻿using System.Collections.Generic;
using HIPS.CommonSchemas;
using HIPS.CommonSchemas.PatientIdentifier;
using HIPS.IhiSchemas.Schemas;
using HIPS.PcehrDataStore.Schemas.Enumerators;
using HIPS.CommonBusinessLogic.Ihi;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using nehta.mcaR3.ConsumerSearchIHI;
using Test.CommonCcaNoc.Helpers;

namespace Test.MedicareCCA.NoticeOfConnection.IHI
{
    [TestClass]
    public class NOC_IHISearch : CcaTest
    {
        /// <summary>
        /// IHI Inquiry Search via B2B (Reference: TECH.SIS.HI.06)
        /// Test 1.1 - Positive
        /// </summary>
        [TestMethod]
        [TestCategory("HI_NOC_IHI_Search")]
        public void HI_NOC_TECH_SIS_HI_06_TEST_1_1()
        {
            patient = CcaPatient.GetPatient(ihiValid: true, validatedWithinPeriod: false, hasUnresolvedAlerts: false, testDataId: "NOC ID 17");
            UserDetails user = patient.GetTestUser();
            PatientIdentifierBase identifier = patient.TargetPatientIdentifier;
            ValidatedIhiResponse ihiResponse = ProxyHelper.IhiProxy.GetValidatedIhi(identifier, patient.TestPatientDateOfBirth, user);
            LogAssert.ExpectResponse(HipsResponseIndicator.OK, ihiResponse.HipsResponse, DialogueResource.HipsServiceGetValidatedIhi);
            LogAssert.AreEqual(patient.IhiInformation.Ihi, ihiResponse.ValidatedIhi.Ihi, DialogueResource.IhiNumber);
        }

        /// <summary>
        /// IHI Inquiry Search via B2B (Reference: TECH.SIS.HI.06)
        /// Test 1.2 - Negative Informational
        /// </summary>
        [TestMethod]
        [TestCategory("HI_NOC_IHI_Search")]
        public void HI_NOC_TECH_SIS_HI_06_TEST_1_2()
        {
            patient = CcaPatient.GetPatient(ihiValid: false, validatedWithinPeriod: false, hasUnresolvedAlerts: false, testDataId: "NOC ID 4");
            UserDetails user = patient.GetTestUser();
            PatientIdentifierBase identifier = patient.TargetPatientIdentifier;
            //ValidatedIhiResponse ihiResponse = ProxyHelper.IhiProxy.GetValidatedIhi(identifier, patient.TestPatientDateOfBirth, user);
            string resultMessage = string.Empty;
            searchIHIResponse ihiResponse = null;
            IhiSearchCriteria searchCriteria = new IhiSearchCriteria();
            searchCriteria.DateOfBirth = patient.TestPatientDateOfBirth;

            IhiSearchCriteriaName name = new IhiSearchCriteriaName();
            name.FamilyName = patient.TargetPatient.CurrentName.FamilyName;
            name.GivenName = patient.TargetPatient.CurrentName.GivenNames;
            name.Sex = (SexEnumerator)patient.TargetPatient.CurrentSexId;
            searchCriteria.Names = new List<IhiSearchCriteriaName>();
            searchCriteria.Names.Add(name);

            searchCriteria.MedicareNumber = "5950165651";
            searchCriteria.IsMedicareNumberValid = true;
            searchCriteria.MedicareIrn = "1";
            searchCriteria.PcehrExists = false;
            searchCriteria.PatientMasterId = (int)patient.TargetPatient.PatientMasterId;

            bool actual = Search.ByNumber(patient.TargetHospital, patient.TargetPatient, searchCriteria, out resultMessage, out ihiResponse, user, false);

            LogAssert.AreEqual(ihiResponse.searchIHIResult.serviceMessages.serviceMessage[0].reason, "(INFORMATION) No Healthcare Individual records have been found.", DialogueResource.ServiceMessage);
            //LogAssert.AreEqual(HipsResponseIndicator.InvalidIhi, ihiResponse.HipsResponse.Status, DialogueResource.InvalidIhi);
        }
    }
}