﻿using System.ServiceModel;
using HIPS.PcehrDataStore.Schemas;
using HIPS.PcehrSchemas;
using HIPS.ServiceContracts.Common;
using HIPS.ServiceContracts.Common.Fault;
using HIPS.ServiceContracts.Pcehr.Message;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Test.CommonCcaNoc.Helpers;

namespace Test.PcehrCcaNoc.ClinicalInformationSystem.UC_CIS_201
{
    /// <summary>
    /// Conformance Test Specification: Clinical Information Systems
    ///                                 Connecting to the PCEHR System
    ///                                 Version 1.6 — 27 September 2012
    /// Use Case #:	    UC.CIS.201
    /// Use Case Name:	Upload a Clinical Document
    /// Test Case ID:   PCEHR_CIS_017842a
    /// Objective:
    /// To check that the CIS provides a mechanism to identify which clinical
    /// documents have been uploaded to the PCEHR System.
    /// </summary>
    [TestClass]
    public class PCEHR_CIS_017842a_1A : CcaTest
    {
        /// <summary>
        /// Create a clinical document for a healthcare recipient using the
        /// software, and upload the clinical document to the PCEHR System:
        /// a. Verify that the software has a mechanism to record that a
        ///    document has been uploaded to the PCEHR.
        /// </summary>
        [TestMethod]
        [TestCategory("CIS_CCA_201_1A")]
        public void CIS_201_017842a_1A()
        {
            patient = CcaPatient.GetPatient(ihiValid: true, validatedWithinPeriod: true, hasUnresolvedAlerts: false, testDataId: "CCA ID IHI_85");

            UploadDischargeSummaryLevel1ARequest request = patient.CreateDocument1ARequest();
            UploadDischargeSummaryLevel1AResponse response = new UploadDischargeSummaryLevel1AResponse();
            try
            {
                response = ProxyHelper.PcehrServiceV2Proxy.UploadOrSupersedeDischargeSummaryLevel1A(request);
            }
            catch (FaultException<ServiceOperationFault>)
            {
                LogAssert.ExpectResponseStatus(ResponseStatus.OK, response.Status, DialogueResource.HipsServiceUploadDocument);
            }

            LogAssert.ExpectResponseStatus(ResponseStatus.OK, response.Status, DialogueResource.HipsServiceUploadDocument);

            Episode episode = patient.TargetEpisode;

            // Demonstrate criteria A, that the software has a mechanism to record that a document has been uploaded to the PCEHR.
            // We will use the HIPS service 'GetOperationStatus' to confirm that the document was uploaded.
            OperationStatus statusResponse = ProxyHelper.PcehrProxy.GetOperationStatus(patient.TargetPatientIdentifier, episode.AdmissionDate, patient.GetTestUser());
            LogAssert.AreEqual(1, statusResponse.UploadedDocuments.Count, DialogueResource.UploadedDocumentsCount);
            LogAssert.AreEqual((int)HIPS.PcehrDataStore.Schemas.Enumerators.ClinicalDocumentStatus.Active, statusResponse.UploadedDocuments[0].ClinicalDocumentStatusId, DialogueResource.UploadedDocumentStatus);
            LogAssert.AreEqual(episode.EpisodeId.Value, statusResponse.UploadedDocuments[0].EpisodeId, DialogueResource.UploadedDocumentEpisodeId);
        }
    }
}