﻿using HIPS.PcehrDataStore.Schemas;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Test.CommonCcaNoc.Helpers;

namespace Test.PcehrCcaNoc.ClinicalInformationSystem.UC_CIS_202
{
    /// <summary>
    /// Conformance Test Specification: Clinical Information Systems
    ///                                 Connecting to the PCEHR System
    ///                                 Version 1.6 — 27 September 2012
    /// Use Case #:	    UC.CIS.202
    /// Use Case Name:	Supersede a Clinical Document
    /// Test Case ID:   PCEHR_CIS_017841b
    /// Objective:
    /// To check that the clinical information either retains any clinical
    /// document uploaded to the PCEHR System, or retains the original
    /// clinical information used to generate the clinical document uploaded
    /// to the PCEHR.
    /// </summary>
    [TestClass]
    public class PCEHR_CIS_017841b : CcaTest
    {
        /// <summary>
        /// Create an amended version of the clinical document created and
        /// uploaded in PCEHR_CIS_017841a in use case UC.CIS.201 using the
        /// software, and supersede uploaded version on the PCEHR System with
        /// the amended version:
        /// Verify that the software system fulfils either criteria a or b:
        /// a. Retains the clinical information used to create the amended
        ///    clinical documents locally.
        /// b. Retains a copy of the amended clinical document that was
        ///    uploaded
        /// </summary>
        [TestMethod]
        [TestCategory("CIS_CCA_202")]
        public void CIS_202_017841b_B()
        {
            // Changed 86 to 85
            patient = CcaPatient.GetPatient(ihiValid: true, validatedWithinPeriod: true, hasUnresolvedAlerts: false, testDataId: "CCA ID IHI_85");
            Episode episode = patient.TargetEpisode;
            CdaDocument cdaDocument1 = patient.CreateNewDocument(SampleDocumentType.DischargeSummary3A);
            QueueHelper.UploadDocumentAndWaitUntilProcessed(patient, LogAssert, cdaDocument1);

            CdaDocument cdaDocument2 = patient.CreateNewDocument(SampleDocumentType.DischargeSummary3A);
            QueueHelper.UploadDocumentAndWaitUntilProcessed(patient, LogAssert, cdaDocument2);

            // Demonstrate criteria B, that the amended document is retained in the hips.ClinicalDocumentVersion table.
            ClinicalDocumentVersion version = patient.GetLastClinicalDocumentVersion();
            byte[] actualContent = CdaPackage.ExtractDocument(version.Package);

            // Make sure that it's not the first one, but the second one.
            Log("First document ID is " + cdaDocument1.GetDocId());
            LogAssert.AreNotEqual(cdaDocument1.GetDocId(), version.SourceSystemDocumentId, DialogueResource.FirstUploadedVersionDocumentId);
            LogAssert.AreEqual(cdaDocument2.GetDocId(), version.SourceSystemDocumentId, DialogueResource.SecondUploadedVersionDocumentId);

            // The binary won't be equal because HIPS adds the integrity check on the logo.
            //CollectionAssert.AreNotEqual(cdaDocument1.GetBytes(), actualContent);
            //CollectionAssert.AreEqual(cdaDocument2.GetBytes(), actualContent);
        }
    }
}