/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.pcehr.clients.common.handler;

import au.gov.nehta.vendorlibrary.pcehr.clients.common.constant.XMLNamespaces;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.exception.MTOMException;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.util.HandlerUtils;
import java.io.InputStream;
import java.util.Set;
import java.util.UUID;
import javax.xml.namespace.QName;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.apache.commons.io.IOUtils;
import org.w3c.dom.NodeList;

public class MTOMHandler
implements SOAPHandler<SOAPMessageContext> {
    public static final String DOCUMENT_ELEM = "Document";
    public static final String UPLOAD_REQUEST_ELEM = "ProvideAndRegisterDocumentSetRequest";
    public static final String INCLUDE_ELEM = "Include";
    public static final String XOP_INCLUDE = "cid:%s";
    private static final String CONTENT_ID_ATTR = "href";
    private static final String OCTET_STREAM_CONTENT_TYPE = "application/octet-stream";

    public final boolean handleMessage(SOAPMessageContext sOAPMessageContext) {
        if (HandlerUtils.isOutgoing(sOAPMessageContext).booleanValue() && HandlerUtils.isResponseType(sOAPMessageContext, XMLNamespaces.IHE.getNamespace(), UPLOAD_REQUEST_ELEM)) {
            try {
                SOAPEnvelope sOAPEnvelope = sOAPMessageContext.getMessage().getSOAPPart().getEnvelope();
                SOAPBody sOAPBody = sOAPEnvelope.getBody();
                UUID uUID = UUID.randomUUID();
                String string = HandlerUtils.extractElementContent(sOAPBody, XMLNamespaces.IHE.getNamespace(), DOCUMENT_ELEM);
                InputStream inputStream = IOUtils.toInputStream((String)string);
                this.createDocumentAttachmentPart(sOAPMessageContext, inputStream, uUID);
                this.replaceDocumentContent(sOAPBody, uUID);
            }
            catch (SOAPException sOAPException) {
                throw new MTOMException("Unable to extract SOAP components", (Exception)((Object)sOAPException));
            }
        }
        return true;
    }

    private void replaceDocumentContent(SOAPBody sOAPBody, UUID uUID) {
        NodeList nodeList = sOAPBody.getElementsByTagNameNS(XMLNamespaces.IHE.getNamespace(), DOCUMENT_ELEM);
        SOAPBodyElement sOAPBodyElement = (SOAPBodyElement)HandlerUtils.getFirstElementFromNodeList(nodeList);
        sOAPBodyElement.removeContents();
        try {
            sOAPBodyElement.addChildElement(INCLUDE_ELEM, XMLNamespaces.XOP.getPrefix(), XMLNamespaces.XOP.getNamespace()).setAttribute(CONTENT_ID_ATTR, String.format(XOP_INCLUDE, uUID.toString()));
        }
        catch (SOAPException sOAPException) {
            throw new MTOMException("Failed to add the new XOP include element to the SOAP body.", (Exception)((Object)sOAPException));
        }
    }

    private void createDocumentAttachmentPart(SOAPMessageContext sOAPMessageContext, InputStream inputStream, UUID uUID) {
        AttachmentPart attachmentPart = sOAPMessageContext.getMessage().createAttachmentPart();
        try {
            attachmentPart.setBase64Content(inputStream, OCTET_STREAM_CONTENT_TYPE);
        }
        catch (SOAPException sOAPException) {
            throw new MTOMException("Failed to create a new attachment part", (Exception)((Object)sOAPException));
        }
        attachmentPart.setContentId(uUID.toString());
        sOAPMessageContext.getMessage().addAttachmentPart(attachmentPart);
    }

    public final boolean handleFault(SOAPMessageContext sOAPMessageContext) {
        return true;
    }

    public void close(MessageContext messageContext) {
    }

    public final Set<QName> getHeaders() {
        return null;
    }
}

