/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.pcehr.clients.common.util;

import au.net.electronichealth.ns.pcehr.xsd.common.commoncoreelements._1.PCEHRHeader;
import java.math.BigInteger;
import org.apache.commons.lang.Validate;

public final class CommonHeaderValidator {
    private static final int EXPECTED_IHI_LENGTH = 16;

    private CommonHeaderValidator() {
    }

    public static void validate(PCEHRHeader pCEHRHeader, boolean bl) {
        Validate.notNull((Object)pCEHRHeader, (String)"'commonHeader' cannot be null.");
        if (bl) {
            Validate.notEmpty((String)pCEHRHeader.getIhiNumber(), (String)"'commonHeader.IHINumber' cannot be null nor empty.");
            CommonHeaderValidator.validateIhi(pCEHRHeader.getIhiNumber());
        }
        Validate.notNull((Object)pCEHRHeader.getUser(), (String)"'commonHeader.user' cannot be null.");
        Validate.notNull((Object)pCEHRHeader.getUser().getIDType(), (String)"'commonHeader.user.idType' cannot be null.");
        Validate.notEmpty((String)pCEHRHeader.getUser().getID(), (String)"'commonHeader.user.id' cannot be null nor empty.");
        Validate.notEmpty((String)pCEHRHeader.getUser().getUserName(), (String)"'commonHeader.user.userName' cannot be null nor empty.");
        if (pCEHRHeader.getUser().isUseRoleForAudit()) {
            Validate.notEmpty((String)pCEHRHeader.getUser().getRole(), (String)"'commonHeader.user.role' must be specified as 'commonHeader.user.userRoleForAudit' is true.");
        }
        Validate.notNull((Object)pCEHRHeader.getProductType(), (String)"'commonHeader.productType' cannot be null.");
        Validate.notEmpty((String)pCEHRHeader.getProductType().getVendor(), (String)"'commonHeader.productType.vendor' cannot be null nor empty.");
        Validate.notEmpty((String)pCEHRHeader.getProductType().getProductName(), (String)"'commonHeader.productType.productName' cannot be null nor empty.");
        Validate.notEmpty((String)pCEHRHeader.getProductType().getProductVersion(), (String)"'commonHeader.productType.productVersion' cannot be null nor empty.");
        Validate.notEmpty((String)pCEHRHeader.getProductType().getPlatform(), (String)"'commonHeader.productType.platform' cannot be null nor empty.");
        Validate.notNull((Object)pCEHRHeader.getClientSystemType(), (String)"'commonHeader.clientSystemType' cannot be null.");
        if (pCEHRHeader.getAccessingOrganisation() != null) {
            Validate.notEmpty((String)pCEHRHeader.getAccessingOrganisation().getOrganisationID(), (String)"'commonHeader.accessingOrganisation.organisationId' cannot be null nor empty.");
            Validate.notEmpty((String)pCEHRHeader.getAccessingOrganisation().getOrganisationName(), (String)"'commonHeader.accessingOrganisation.organisationName' cannot be null nor empty.");
        }
    }

    private static void validateIhi(String string) {
        Validate.notEmpty((String)string, (String)"'ihi' must not be null nor empty.");
        if (string.length() != 16) {
            throw new IllegalArgumentException("'ihi' length must be 16 digits.");
        }
        try {
            new BigInteger(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("'ihi' must only contain digits.", numberFormatException);
        }
        if (!string.startsWith("800360")) {
            throw new IllegalArgumentException("'ihi' must be of the format 800360XXXXXXXXXX.");
        }
    }
}

