/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.pcehr.clients.common.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.io.IOUtils;

public final class FileUtils {
    private static final int BUFFER_SIZE = 16384;

    private FileUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] loadFile(File file) throws IOException {
        if (!file.exists()) {
            throw new IllegalArgumentException("The file [" + file + "] does not exist.");
        }
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[16384];
            while ((n = fileInputStream.read(byArray, 0, byArray.length)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byteArrayOutputStream.flush();
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            return byArray2;
        }
    }

    public static <T> T loadXml(File file, Class<? extends T> clazz) throws JAXBException {
        if (!file.exists()) {
            throw new IllegalArgumentException("The file [" + file + "] does not exist.");
        }
        JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
        Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
        return (T)unmarshaller.unmarshal(file);
    }

    public static byte[] getCdaDocument(byte[] byArray) {
        Map<String, byte[]> map;
        try {
            map = FileUtils.extractZipEntries(byArray);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Failed to read package content.", iOException);
        }
        for (Map.Entry<String, byte[]> entry : map.entrySet()) {
            String string = entry.getKey();
            Pattern pattern = Pattern.compile("[/\\\\]?[^/\\\\]+[/\\\\][^/\\\\]+[/\\\\]CDA_ROOT.XML", 2);
            if (!pattern.matcher(string).matches()) continue;
            return entry.getValue();
        }
        throw new IllegalArgumentException("Failed to retrieve root document from package.");
    }

    private static byte[] readZipEntry(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[16384];
        int n = inputStream.read(byArray);
        while (n != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
            n = inputStream.read(byArray);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static Map<String, byte[]> extractZipEntries(byte[] byArray) throws IOException {
        HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
        ZipInputStream zipInputStream = new ZipInputStream(new ByteArrayInputStream(byArray));
        ZipEntry zipEntry = null;
        try {
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (zipEntry.isDirectory()) continue;
                hashMap.put(zipEntry.getName(), FileUtils.readZipEntry(zipInputStream));
            }
        }
        catch (IOException iOException) {
            throw new IOException("Unable to extract ZIP entries.", iOException);
        }
        finally {
            IOUtils.closeQuietly((InputStream)zipInputStream);
        }
        return hashMap;
    }
}

