/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.common.security;

import au.gov.nehta.common.utils.ArgumentUtils;
import au.gov.nehta.vendorlibrary.common.DOMUtil;
import au.gov.nehta.xsp.CertificateValidationException;
import au.gov.nehta.xsp.CertificateValidator;
import au.gov.nehta.xsp.CertificateVerificationException;
import au.gov.nehta.xsp.CertificateVerifier;
import au.gov.nehta.xsp.SignatureValidationException;
import au.gov.nehta.xsp.SignedContainerProfileService;
import au.gov.nehta.xsp.XspException;
import au.gov.nehta.xsp.XspFactory;
import au.gov.nehta.xsp.XspVersion;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.security.auth.x500.X500PrivateCredential;
import org.w3c.dom.Document;

public final class SignedContainerProfileUtil {
    public static final CertificateVerifier NULL_CERTIFICATE_VERIFIER = new CertificateVerifier(){

        public void verify(X509Certificate x509Certificate) throws CertificateVerificationException, XspException {
        }
    };
    public static final CertificateValidator NULL_CERTIFICATE_VALIDATOR = new CertificateValidator(){

        public void validate(X509Certificate x509Certificate) throws CertificateValidationException, XspException {
        }
    };
    private static final Logger LOG = Logger.getLogger(SignedContainerProfileUtil.class.getName());

    private SignedContainerProfileUtil() {
    }

    public static Document getSignedPayload(String string, X509Certificate x509Certificate, PrivateKey privateKey) throws XspException {
        ArgumentUtils.checkNotNullNorBlank((String)string, (String)"sensitivePayload");
        ArgumentUtils.checkNotNull((Object)x509Certificate, (String)"siginingCert");
        ArgumentUtils.checkNotNull((Object)privateKey, (String)"siginingPrivateKey");
        ArrayList<X500PrivateCredential> arrayList = new ArrayList<X500PrivateCredential>();
        arrayList.add(new X500PrivateCredential(x509Certificate, privateKey));
        return SignedContainerProfileUtil.getSignedPayload(string, arrayList);
    }

    public static Document getSignedPayload(String string, List<X500PrivateCredential> list) throws XspException {
        try {
            ArgumentUtils.checkNotNullNorBlank((String)string, (String)"sensitivePayload");
            ArgumentUtils.checkNotNull(list, (String)"certificateKeyPairs");
            if (list.size() > 0) {
                Document document = null;
                Document document2 = DOMUtil.getDocumentFromXML(string);
                document = SignedContainerProfileUtil.getSignedContainerProfileService().create(document2, list);
                return document;
            }
        }
        catch (XspException xspException) {
            throw new XspException("Failed to sign the document.");
        }
        throw new XspException("Failed to sign the document.");
    }

    public static List<byte[]> getDigestValue(Document document) throws XspException {
        return SignedContainerProfileUtil.getSignedContainerProfileService().getDigestValues(document);
    }

    public static List<X509Certificate> getSigningCertificates(Document document) throws XspException {
        return SignedContainerProfileUtil.getSignedContainerProfileService().getSigningCertificates(document);
    }

    public static Document getDataFromSignedPayload(Document document) throws XspException {
        ArgumentUtils.checkNotNull((Object)document, (String)"signedDocument");
        Document document2 = null;
        try {
            document2 = SignedContainerProfileUtil.getSignedContainerProfileService().getData(document);
            ArgumentUtils.checkNotNull((Object)document2, (String)"extractedDocument");
            return document2;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new XspException((Throwable)illegalArgumentException);
        }
        catch (XspException xspException) {
            return document2;
        }
    }

    public static boolean verifySignature(Document document, CertificateVerifier certificateVerifier) throws SignatureValidationException {
        boolean bl = false;
        ArgumentUtils.checkNotNull((Object)document, (String)"signedDocument");
        Object var3_3 = null;
        try {
            SignedContainerProfileUtil.getSignedContainerProfileService().check(document, (CertificateValidator)certificateVerifier);
            bl = true;
        }
        catch (XspException xspException) {
            throw new SignatureValidationException("Failed to verify the signature", (Throwable)xspException);
        }
        catch (CertificateVerificationException certificateVerificationException) {
            throw new SignatureValidationException("Failed to verify the signature", (Throwable)certificateVerificationException);
        }
        catch (CertificateValidationException certificateValidationException) {
            throw new SignatureValidationException("Failed to verify the signature", (Throwable)certificateValidationException);
        }
        return bl;
    }

    public static boolean verifySignature(Document document, CertificateValidator certificateValidator) throws SignatureValidationException {
        boolean bl = false;
        ArgumentUtils.checkNotNull((Object)document, (String)"signedDocument");
        Object var3_3 = null;
        try {
            SignedContainerProfileUtil.getSignedContainerProfileService().check(document, certificateValidator);
            bl = true;
        }
        catch (XspException xspException) {
            throw new SignatureValidationException("Failed to verify the signature", (Throwable)xspException);
        }
        catch (CertificateValidationException certificateValidationException) {
            throw new SignatureValidationException("Failed to verify the signature", (Throwable)certificateValidationException);
        }
        return bl;
    }

    public static boolean verifySignature(Document document) throws SignatureValidationException {
        return SignedContainerProfileUtil.verifySignature(document, NULL_CERTIFICATE_VALIDATOR);
    }

    private static SignedContainerProfileService getSignedContainerProfileService() throws XspException {
        return XspFactory.getInstance().getSignedContainerProfileService(XspVersion.V_2010);
    }
}

