/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys.storage.implementations;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.keys.content.x509.XMLX509SKI;
import org.apache.xml.security.keys.storage.StorageResolverException;
import org.apache.xml.security.keys.storage.StorageResolverSpi;
import org.apache.xml.security.utils.Base64;

public class CertsInFilesystemDirectoryResolver
extends StorageResolverSpi {
    static Log log = LogFactory.getLog((String)CertsInFilesystemDirectoryResolver.class.getName());
    String _merlinsCertificatesDir = null;
    private List _certs = new ArrayList();
    Iterator _iterator = null;

    public CertsInFilesystemDirectoryResolver(String string) throws StorageResolverException {
        this._merlinsCertificatesDir = string;
        this.readCertsFromHarddrive();
        this._iterator = new FilesystemIterator(this._certs);
    }

    private void readCertsFromHarddrive() throws StorageResolverException {
        File file = new File(this._merlinsCertificatesDir);
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (!string.endsWith(".crt")) continue;
            arrayList.add(stringArray[i]);
        }
        CertificateFactory certificateFactory = null;
        try {
            certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            throw new StorageResolverException("empty", certificateException);
        }
        if (certificateFactory == null) {
            throw new StorageResolverException("empty");
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = file.getAbsolutePath() + File.separator + (String)arrayList.get(i);
            File file2 = new File(string);
            boolean bl = false;
            String string2 = null;
            try {
                FileInputStream fileInputStream = new FileInputStream(file2);
                X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(fileInputStream);
                fileInputStream.close();
                x509Certificate.checkValidity();
                this._certs.add(x509Certificate);
                string2 = x509Certificate.getSubjectDN().getName();
                bl = true;
            }
            catch (FileNotFoundException fileNotFoundException) {
                log.debug((Object)("Could not add certificate from file " + string), (Throwable)fileNotFoundException);
            }
            catch (IOException iOException) {
                log.debug((Object)("Could not add certificate from file " + string), (Throwable)iOException);
            }
            catch (CertificateNotYetValidException certificateNotYetValidException) {
                log.debug((Object)("Could not add certificate from file " + string), (Throwable)certificateNotYetValidException);
            }
            catch (CertificateExpiredException certificateExpiredException) {
                log.debug((Object)("Could not add certificate from file " + string), (Throwable)certificateExpiredException);
            }
            catch (CertificateException certificateException) {
                log.debug((Object)("Could not add certificate from file " + string), (Throwable)certificateException);
            }
            if (!bl || !log.isDebugEnabled()) continue;
            log.debug((Object)("Added certificate: " + string2));
        }
    }

    public Iterator getIterator() {
        return this._iterator;
    }

    public static void main(String[] stringArray) throws Exception {
        CertsInFilesystemDirectoryResolver certsInFilesystemDirectoryResolver = new CertsInFilesystemDirectoryResolver("data/ie/baltimore/merlin-examples/merlin-xmldsig-eighteen/certs");
        Iterator iterator = certsInFilesystemDirectoryResolver.getIterator();
        while (iterator.hasNext()) {
            X509Certificate x509Certificate = (X509Certificate)iterator.next();
            byte[] byArray = XMLX509SKI.getSKIBytesFromCert(x509Certificate);
            System.out.println();
            System.out.println("Base64(SKI())=                 \"" + Base64.encode(byArray) + "\"");
            System.out.println("cert.getSerialNumber()=        \"" + x509Certificate.getSerialNumber().toString() + "\"");
            System.out.println("cert.getSubjectDN().getName()= \"" + x509Certificate.getSubjectDN().getName() + "\"");
            System.out.println("cert.getIssuerDN().getName()=  \"" + x509Certificate.getIssuerDN().getName() + "\"");
        }
    }

    private static class FilesystemIterator
    implements Iterator {
        List _certs = null;
        int _i;

        public FilesystemIterator(List list) {
            this._certs = list;
            this._i = 0;
        }

        public boolean hasNext() {
            return this._i < this._certs.size();
        }

        public Object next() {
            return this._certs.get(this._i++);
        }

        public void remove() {
            throw new UnsupportedOperationException("Can't remove keys from KeyStore");
        }
    }
}

