/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.common.utils;

import au.gov.nehta.common.utils.ArgumentUtils;
import au.gov.nehta.common.utils.DomUtils;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class JaxbUtils {
    private static Map<String, JAXBContext> contextCache = new HashMap<String, JAXBContext>();

    public static <T> T unmarshal(Node xmlNode, Class<T> jaxbClass) throws JAXBException {
        ArgumentUtils.checkNotNull(xmlNode, "xmlNode");
        ArgumentUtils.checkNotNull(jaxbClass, "jaxbClass");
        return JaxbUtils.unmarshal(new DOMSource(xmlNode), jaxbClass);
    }

    public static <T> T unmarshal(Reader reader, Class<T> jaxbClass) throws JAXBException {
        ArgumentUtils.checkNotNull(reader, "reader");
        ArgumentUtils.checkNotNull(jaxbClass, "jaxbClass");
        return JaxbUtils.unmarshal(new StreamSource(reader), jaxbClass);
    }

    private static <T> T unmarshal(Source xmlContents, Class<T> jaxbClass) throws JAXBException {
        assert (xmlContents != null);
        assert (jaxbClass != null);
        JAXBContext context = JaxbUtils.getContext(jaxbClass);
        Unmarshaller unmarshaller = context.createUnmarshaller();
        JAXBElement jaxbElem = unmarshaller.unmarshal(xmlContents, jaxbClass);
        return (T)jaxbElem.getValue();
    }

    public static void marshal(JAXBElement value, Writer output) throws JAXBException, IOException {
        ArgumentUtils.checkNotNull(value, "value");
        ArgumentUtils.checkNotNull(output, "output");
        JAXBContext context = JaxbUtils.getContext(value.getDeclaredType());
        Marshaller marshaller = context.createMarshaller();
        marshaller.marshal((Object)value, output);
        output.flush();
    }

    public static String marshalToString(JAXBElement value) throws JAXBException {
        ArgumentUtils.checkNotNull(value, "value");
        JAXBContext context = JaxbUtils.getContext(value.getDeclaredType());
        Marshaller marshaller = context.createMarshaller();
        StringWriter writer = new StringWriter();
        marshaller.marshal((Object)value, (Writer)writer);
        writer.flush();
        return writer.toString();
    }

    public static Document marshalToDom(JAXBElement value) throws JAXBException, ParserConfigurationException {
        ArgumentUtils.checkNotNull(value, "value");
        JAXBContext context = JaxbUtils.getContext(value.getDeclaredType());
        Marshaller marshaller = context.createMarshaller();
        Document doc = DomUtils.newDocument();
        marshaller.marshal((Object)value, (Node)doc);
        return doc;
    }

    private static JAXBContext getContext(Class jaxbClass) throws JAXBException {
        assert (jaxbClass != null);
        assert (jaxbClass.getPackage() != null);
        return JaxbUtils.getContext(jaxbClass.getPackage().getName());
    }

    private static JAXBContext getContext(String packageName) throws JAXBException {
        assert (packageName != null);
        JAXBContext context = contextCache.get(packageName);
        if (context == null) {
            context = JAXBContext.newInstance((String)packageName);
            contextCache.put(packageName, context);
        }
        return context;
    }
}

