/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.pcehr.clients.common.handler;

import au.gov.nehta.common.utils.ArgumentUtils;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.constant.XMLNamespaces;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.exception.CertificateVerificationException;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.exception.SignatureValidationException;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.exception.SignatureVerificationException;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.util.HandlerUtils;
import au.gov.nehta.xsp.CertificateValidationException;
import au.gov.nehta.xsp.CertificateValidator;
import au.gov.nehta.xsp.XmlSignatureProfileService;
import au.gov.nehta.xsp.XspException;
import au.gov.nehta.xsp.XspFactory;
import au.gov.nehta.xsp.XspVersion;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.security.auth.x500.X500PrivateCredential;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.apache.commons.lang.Validate;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SecurityHandler
implements SOAPHandler<SOAPMessageContext> {
    public static final String TIMESTAMP = "timestamp";
    public static final String SIGNATURE_ELEM = "signature";
    public static final String GET_DOCUMENT_ELEM = "RetrieveDocumentSetResponse";
    public static final String DSIG_ELEM = "Signature";
    public static final String PCEHRH_HEADER_ELEM = "PCEHRHeader";
    private static final int DIGEST_VALUE_COUNT = 1;
    private static final String TS_PREFIX = "t_";
    private static final String BODY_PREFIX = "b_";
    private static final String HEADER_PREFIX = "h_";
    private static final String ID_ATTR = "xml:id";
    private final X509Certificate x509Certificate;
    private final PrivateKey privateKey;
    private final CertificateValidator certificateVerifier;

    public SecurityHandler(X509Certificate x509Certificate, PrivateKey privateKey, CertificateValidator certificateValidator) {
        Validate.notNull((Object)x509Certificate, (String)"'x509Certificate' cannot be null.");
        Validate.notNull((Object)certificateValidator, (String)"'certificateVerifier' cannot be null. Consider an empty implementation if verification is not required.");
        Validate.notNull((Object)privateKey, (String)"'privateKey' cannot be null.");
        this.x509Certificate = x509Certificate;
        this.privateKey = privateKey;
        this.certificateVerifier = certificateValidator;
    }

    public final boolean handleMessage(SOAPMessageContext sOAPMessageContext) {
        if (HandlerUtils.isOutgoing(sOAPMessageContext).booleanValue()) {
            this.signBodyAndSOAPHeaders(sOAPMessageContext);
        } else {
            try {
                this.checkResponse(sOAPMessageContext);
            }
            catch (CertificateVerificationException certificateVerificationException) {
                throw new SignatureVerificationException("Certificate verification failed", certificateVerificationException);
            }
        }
        return true;
    }

    private void checkResponse(SOAPMessageContext sOAPMessageContext) {
        Element element = this.validateSignature(sOAPMessageContext);
        XmlSignatureProfileService xmlSignatureProfileService = null;
        try {
            xmlSignatureProfileService = XspFactory.getInstance().getXmlSignatureProfileService(XspVersion.V_2010);
        }
        catch (XspException xspException) {
            throw new SignatureValidationException("Unable to validate signature", (Exception)((Object)xspException));
        }
        try {
            xmlSignatureProfileService.check(element, this.certificateVerifier);
        }
        catch (au.gov.nehta.xsp.SignatureValidationException signatureValidationException) {
            throw new SignatureValidationException("Signature validation failed.", (Exception)((Object)signatureValidationException));
        }
        catch (au.gov.nehta.xsp.CertificateVerificationException certificateVerificationException) {
            throw new SignatureValidationException("Signature validation failed.", (Exception)((Object)certificateVerificationException));
        }
        catch (XspException xspException) {
            throw new SignatureValidationException("Signature validation failed.", (Exception)((Object)xspException));
        }
        catch (CertificateValidationException certificateValidationException) {
            throw new SignatureValidationException("Signature validation failed.", (Exception)((Object)certificateValidationException));
        }
    }

    public final boolean handleFault(SOAPMessageContext sOAPMessageContext) {
        return true;
    }

    public final Set<QName> getHeaders() {
        return null;
    }

    public void close(MessageContext messageContext) {
    }

    private void signBodyAndSOAPHeaders(SOAPMessageContext sOAPMessageContext) {
        Validate.notNull((Object)sOAPMessageContext, (String)"SOAPMessageContext cannot be null");
        try {
            SOAPEnvelope sOAPEnvelope = sOAPMessageContext.getMessage().getSOAPPart().getEnvelope();
            SOAPHeader sOAPHeader = sOAPEnvelope.getHeader();
            SOAPBody sOAPBody = sOAPEnvelope.getBody();
            this.extractAndSignSoapElements(sOAPHeader, (Element)sOAPBody);
        }
        catch (SOAPException sOAPException) {
            throw new RuntimeException(sOAPException.getMessage(), sOAPException);
        }
        catch (XspException xspException) {
            throw new RuntimeException(xspException.getMessage(), xspException);
        }
    }

    private void extractAndSignSoapElements(SOAPHeader sOAPHeader, Element element) throws XspException {
        Validate.notNull((Object)sOAPHeader, (String)"Outgoing message SOAP header cannot be null.");
        Validate.notNull((Object)element, (String)"Outgoing message SOAP body cannot be null.");
        NodeList nodeList = sOAPHeader.getElementsByTagNameNS(XMLNamespaces.COMMON.getNamespace(), TIMESTAMP);
        NodeList nodeList2 = sOAPHeader.getElementsByTagNameNS(XMLNamespaces.COMMON.getNamespace(), SIGNATURE_ELEM);
        NodeList nodeList3 = sOAPHeader.getElementsByTagNameNS(XMLNamespaces.COMMON.getNamespace(), PCEHRH_HEADER_ELEM);
        Element element2 = HandlerUtils.getFirstElementFromNodeList(nodeList);
        Element element3 = HandlerUtils.getFirstElementFromNodeList(nodeList2);
        Element element4 = HandlerUtils.getFirstElementFromNodeList(nodeList3);
        this.signSoapElements(element2, element4, element, element3);
    }

    private void registerIDAtttributes(Document document) {
        NodeList nodeList = document.getDocumentElement().getElementsByTagNameNS("http://www.w3.org/2003/05/soap-envelope", "Body");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            Attr attr = element.getAttributeNode(ID_ATTR);
            element.setIdAttributeNode(attr, true);
        }
    }

    private void signSoapElements(Element element, Element element2, Element element3, Element element4) throws XspException {
        List<Element> list = Arrays.asList(element, element2, element3);
        List<X500PrivateCredential> list2 = Arrays.asList(new X500PrivateCredential(this.x509Certificate, this.privateKey));
        XmlSignatureProfileService xmlSignatureProfileService = XspFactory.getInstance().getXmlSignatureProfileService(XspVersion.V_2010);
        xmlSignatureProfileService.sign(element4, list, list2);
    }

    private Element validateSignature(SOAPMessageContext sOAPMessageContext) {
        Validate.notNull((Object)sOAPMessageContext, (String)"'context' cannot be null.");
        SOAPHeader sOAPHeader = null;
        try {
            sOAPHeader = sOAPMessageContext.getMessage().getSOAPHeader();
        }
        catch (SOAPException sOAPException) {
            throw new SignatureValidationException("Unable to extract SOAP header.", (Exception)((Object)sOAPException));
        }
        if (sOAPHeader == null) {
            throw new SignatureValidationException("Unable to extract SOAP header.");
        }
        this.registerIDAtttributes(sOAPHeader.getOwnerDocument());
        NodeList nodeList = sOAPHeader.getElementsByTagNameNS(XMLNamespaces.DS.getNamespace(), DSIG_ELEM);
        Element element = HandlerUtils.getFirstElementFromNodeList(nodeList);
        if (element == null) {
            throw new CertificateVerificationException("Unable to extract signature fragment.");
        }
        return element;
    }

    private void addSignatureReferenceId(Element element, Element element2, Element element3) {
        Validate.notNull((Object)element, (String)"'bodyElement' cannot be null.");
        ArgumentUtils.checkNotNull((Object)element2, (String)"'timestampElement' cannot be null.");
        ArgumentUtils.checkNotNull((Object)element3, (String)"'headerElement' cannot be null.");
        element3.setAttribute(ID_ATTR, HEADER_PREFIX + UUID.randomUUID().toString());
        element.setAttribute(ID_ATTR, BODY_PREFIX + UUID.randomUUID().toString());
        element2.setAttribute(ID_ATTR, TS_PREFIX + UUID.randomUUID().toString());
    }
}

