/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.pcehr.clients.common.util;

import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.apache.commons.lang.Validate;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class HandlerUtils {
    private HandlerUtils() {
    }

    public static Element getFirstElementFromNodeList(NodeList nodeList) {
        Validate.notNull((Object)nodeList, (String)"'nodeList' cannot be null.");
        Element element = null;
        if (nodeList.getLength() > 0) {
            Validate.notNull((Object)nodeList.item(0), (String)"'nodeList.item' cannot be null.");
            element = (Element)nodeList.item(0);
        }
        return element;
    }

    public static boolean isResponseType(SOAPMessageContext sOAPMessageContext, String string, String string2) {
        Validate.notNull((Object)sOAPMessageContext, (String)"SOAPMessageContext cannot be null");
        boolean bl = false;
        try {
            SOAPEnvelope sOAPEnvelope = sOAPMessageContext.getMessage().getSOAPPart().getEnvelope();
            SOAPBody sOAPBody = sOAPEnvelope.getBody();
            NodeList nodeList = sOAPBody.getElementsByTagNameNS(string, string2);
            if (nodeList.getLength() > 0) {
                bl = true;
            }
        }
        catch (SOAPException sOAPException) {
            throw new RuntimeException(sOAPException.getMessage(), sOAPException);
        }
        return bl;
    }

    public static Boolean isOutgoing(SOAPMessageContext sOAPMessageContext) {
        return (Boolean)sOAPMessageContext.get((Object)"javax.xml.ws.handler.message.outbound");
    }

    public static String extractElementContent(SOAPBody sOAPBody, String string, String string2) {
        NodeList nodeList = sOAPBody.getElementsByTagNameNS(string, string2);
        Element element = HandlerUtils.getFirstElementFromNodeList(nodeList);
        if (element != null && element.getFirstChild() != null) {
            return element.getFirstChild().getNodeValue();
        }
        return null;
    }
}

