﻿namespace HIPS.Web.Model.Common
{
    /// <summary>
    /// Represents an application setting.
    /// </summary>
    public class Setting
    {
        /// <summary>
        /// Gets or sets the setting identifier.
        /// </summary>
        public int SettingId { get; set; }

        /// <summary>
        /// Gets or sets the setting code.
        /// </summary>
        public string Code { get; set; }

        /// <summary>
        /// Gets or sets the setting value.
        /// </summary>
        public string Value { get; set; }

        /// <summary>
        /// Represents the known setting codes.
        /// </summary>
        public enum SettingCodes
        {
            DefaultHospitalCodeSystem,
            PcehrViewPDDocumentClasses,
            PcehrViewServiceDateDocumentClasses,
            PcehrViewFromDateOffsetMonths,
            PcehrViewPatientDaysDischarged,
            PatientsWithoutIhiDaysDischarged,
            DiscloseHiddenPcehrDaysDischarged,
            WithdrawConsentPatientListDaysDischarged,
            WithdrawConsentEpisodeListDaysDischarged,
            RemoveDocumentDaysDischarged,
            DischargeSummaryPatientListDaysDischarged,
            DischargeSummaryEpisodeListDaysDischarged,
            DischargeSummaryDocumentTypeCode,
            DischargeSummaryDocumentFormatCode,
            DischargeSummaryAuthor,
            DischargeSummaryRHP,
            SecurityGroupCodeSystem
        }
    }
}