﻿using System;
using System.Collections.Generic;

using HIPS.Web.Components.ServiceModel;
using HIPS.Web.Model.Common;

namespace HIPS.Web.ModelInterface.ConsentManagement
{
    /// <summary>
    /// Defines the operations to be supported by an implementation of an episode repository.
    /// </summary>
    public interface IEpisodeRepositoryV2 : IDisposable
    {
        /// <summary>
        /// Retrieves a list of recent episodes for a patient at a hospital.
        /// </summary>
        /// <param name="patientIdentifier">The MRN that identifies the patient at the hospital.</param>
        /// <param name="includeDocuments">A value indicating whether documents should be included as part of episode response.</param>
        /// <param name="documentTypeCode">Code of the document to be included.</param>
        /// <param name="userContext">User requesting the operation.</param>
        /// <returns>ServiceResponse containing a PatientEpisodeListResponse containing the results of the operation.</returns>
        ServiceResponse<List<PatientEpisode>> ListPatientEpisodesInHospital(
            CommonSchemas.PatientIdentifier.Mrn patientIdentifier,
            bool includeDocuments,
            string documentTypeCode,
            HIPS.Web.Model.Identity.LocalUser userContext);

        /// <summary>
        /// Retrieves a list of recent episodes for a patient at a hospital.
        /// </summary>
        /// <param name="patientIdentifier">The MRN that identifies the patient at the hospital.</param>
        /// <param name="includeDocuments">A value indicating whether documents should be included as part of episode response.</param>
        /// <param name="documentTypeCode">Code of the document to be included.</param>
        /// <param name="userContext">User requesting the operation.</param>
        /// <returns>ServiceResponse containing a PatientEpisodeListResponse containing the results of the operation.</returns>
        ServiceResponse<List<PatientEpisode>> ListPatientEpisodesInHospital(
            CommonSchemas.PatientIdentifier.RegisteredEnterprisePatient patientIdentifier,
            bool includeDocuments,
            string documentTypeCode,
            HIPS.Web.Model.Identity.LocalUser userContext);
    }
}