﻿using System.Web;

using HIPS.Web.ModelInterface.Common;

namespace HIPS.Web.UI.Helpers
{
    /// <summary>
    /// Provides management of session-based temporary data using HTTP session state.
    /// </summary>
    public class HttpSessionProvider : ISessionProvider
    {
        #region Methods

        /// <summary>
        /// Get the value identified by the specified key from the session store.
        /// </summary>
        /// <param name="key">Key used to identify the value to retrieve from the session store.</param>
        /// <returns>Value identified by the key if available in the session store, null otherwise.</returns>
        public object Get(string key)
        {
            return HttpContext.Current.Session[key];
        }

        /// <summary>
        /// Set the value in the session store using the specified key.
        /// </summary>
        /// <param name="key">Key used to identify the item when inserted into the session store.</param>
        /// <param name="value">Value to insert into the session store.</param>
        public void Set(string key, object value)
        {
            HttpContext.Current.Session[key] = value;
        }

        #endregion Methods
    }
}