﻿using AutoMapper;
using HIPS.PcehrSchemas;
using HIPS.Web.UI.ViewModels.DocumentManagement;
using HIPS.Web.UI.ViewModels.PcehrView;
using DocumentUpload = HIPS.Web.UI.ViewModels.DocumentUpload;

namespace HIPS.Web.UI.Helpers.Mapping.Profiles
{
    /// <summary>
    /// AutoMapper mapping profile for the Document entity.
    /// </summary>
    internal class DocumentProfile : Profile
    {
        /// <summary>
        /// Returns the name of the mapping profile.
        /// </summary>
        public override string ProfileName
        {
            get { return this.GetType().Name; }
        }

        #region Methods

        /// <summary>
        /// Configures the maps available as part of this mapping profile.
        /// </summary>
        protected override void Configure()
        {
            // Data --> ViewModel:
            this.CreateMap<DocumentMetaDataItem, DocumentViewModel>()
                .ForMember(dest => dest.Author, opt => opt.MapFrom(src => string.Format("{0}, {1}", src.AuthorPersonFamilyName, src.AuthorPersonGivenName)))
                .ForMember(dest => dest.CreationDate, opt => opt.MapFrom(src => src.CreationTime))
                .ForMember(dest => dest.DocumentId, opt => opt.MapFrom(src => src.DocumentUniqueId))
                .ForMember(dest => dest.CategoryCode, opt => opt.MapFrom(src => src.DocumentClassCode))
                .ForMember(dest => dest.CategoryName, opt => opt.MapFrom(src => src.DocumentClassName))
                .ForMember(dest => dest.Organisation, opt => opt.MapFrom(src => src.AuthorInstitutionName))
                .ForMember(dest => dest.RepositoryId, opt => opt.MapFrom(src => src.RepositoryUniqueId))
                .ForMember(dest => dest.ServiceEndDate, opt => opt.MapFrom(src => src.ServiceStopTime))
                .ForMember(dest => dest.ServiceStartDate, opt => opt.MapFrom(src => src.ServiceStartTime));

            // Data --> UploadedDocumentViewModel
            this.CreateMap<LocalClinicalDocumentMetaData, UploadedDocumentViewModel>();

            // ViewModel --> Data
            this.CreateMap<DocumentUpload.CreateDocumentViewModel, HIPS.Web.Model.Cda.CdaHeaderMetadata>()
                .ForMember(dest => dest.AdmissionDateTime, opt => opt.MapFrom(src => src.CurrentEpisode.AdmissionDate))
                .ForMember(dest => dest.DischargeDateTime, opt => opt.MapFrom(src => src.CurrentEpisode.DischargeDate.Value))
                .ForMember(dest => dest.DocumentCreationDateTime, opt => opt.MapFrom(src => src.CompletionDate))
                .ForMember(dest => dest.Specialty, opt => opt.MapFrom(src => src.ClinicalSpecialtyCode))
                .ForMember(dest => dest.SourceDocumentStatus, opt => opt.MapFrom(src => src.SourceDocumentStatusId))
                .ForMember(dest => dest.ModeOfSeparation, opt => opt.MapFrom(src => src.ModesOfSeparationId))
                .ForMember(dest => dest.DocumentAuthor, opt => opt.MapFrom(src => src.CurrentUser))
                .ForMember(dest => dest.ResponsibleHealthProfessional, opt => opt.MapFrom(src => src.ResponsibleUser));

            this.CreateMap<DocumentUpload.UserViewModel, HIPS.Web.Model.ParticipatingIndividual.ParticipatingProvider>()
                .ForMember(dest => dest.LocalIdentifier, opt => opt.MapFrom(src => src.UserID))
                .ForMember(dest => dest.Hpii, opt => opt.MapFrom(src => src.HpiI))
                .ForMember(dest => dest.FamilyName, opt => opt.MapFrom(src => src.FamilyName))
                .ForMember(dest => dest.GivenNames, opt => opt.MapFrom(src => src.GivenNames));
        }

        #endregion Methods
    }
}