﻿using System.ComponentModel.DataAnnotations;
using System.Text;
using System.Web.Mvc;

namespace HIPS.Web.UI.ViewModels.DisclosureManagement
{
    /// <summary>
    /// View model for the form for administering a request to disclose or remove disclosure of the existence of a PCEHR.
    /// </summary>
    public class DisclosePcehrViewModel : DisclosureManagementViewModelBase
    {
        #region Constructors

        /// <summary>
        /// Initialises a new instance of the <see cref="DisclosePcehrViewModel" /> class.
        /// </summary>
        /// <param name="hospitalId">The hospital identifier.</param>
        /// <param name="patientId">The patient identifier.</param>
        public DisclosePcehrViewModel(string hospitalId, string patientId)
        {
            this.HospitalId = hospitalId;
            this.PatientId = patientId;
        }

        /// <summary>
        /// Initialises a new instance of the <see cref="DisclosePcehrViewModel" /> class.
        /// Parameter-less constructor required for System.Web.Mvc.DefaultModelBinder to create model.
        /// </summary>
        public DisclosePcehrViewModel()
        {
        }

        #endregion Constructors

        #region Properties

        /// <summary>
        /// Gets or sets the notes entered by the user.
        /// </summary>
        [Required]
        [Display(Name = "Reference Notes")]
        [AllowHtml]
        [MaxLength(5000, ErrorMessage = "The maximum length for Reference Notes is 5000 characters.")]
        public string Notes { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether the user has checked the confirmation checkbox.
        /// </summary>
        [Required]
        public bool Confirm { get; set; }

        /// <summary>
        /// Gets or sets the audit information associated with the previous disclosure of PCEHR, as binary data.
        /// </summary>
        public byte[] DisclosureAuditInformation { get; set; }

        /// <summary>
        /// Gets the audit information associated with the previous disclosure of PCEHR, as a string.
        /// </summary>
        public string DisclosureNotes
        {
            get
            {
                return this.DisclosureAuditInformation == null ? "(None)" : Encoding.UTF8.GetString(this.DisclosureAuditInformation);
            }
        }

        #endregion Properties
    }
}