﻿using System;

using HIPS.Web.UI.ViewModels.Shared;

namespace HIPS.Web.UI.ViewModels.DocumentUpload
{
    /// <summary>
    /// View model for uploading/superseding discharge summary document.
    /// </summary>
    public class UploadDocumentViewModel
    {
        #region Constructors

        /// <summary>
        /// Initialises a new instance of the <see cref="UploadDocumentViewModel" /> class.
        /// </summary>
        public UploadDocumentViewModel()
        {
            this.Messages = new ViewMessageList();
        }

        #endregion Constructors

        #region Properties

        /// <summary>
        /// Gets or sets the list of messages associated with the view model.
        /// </summary>
        public ViewMessageList Messages { get; set; }

        /// <summary>
        /// Gets or sets the date and time when the patient was admitted.
        /// </summary>
        public DateTime AdmissionDate { get; set; }

        /// <summary>
        /// Gets or sets Document status.
        /// </summary>
        public string DocumentStatus { get; set; }

        /// <summary>
        /// Gets or sets the identifier (code) associated with the selected hospital.
        /// </summary>
        public string HospitalId { get; set; }

        /// <summary>
        /// Gets or sets the identifier (MRN) associated with the selected patient.
        /// </summary>
        public string PatientId { get; set; }

        /// <summary>
        /// Gets or sets the identifier associated with the selected document.
        /// </summary>
        public string DocumentSetId { get; set; }

        #endregion Properties
    }
}