﻿namespace HIPS.Web.UI.ViewModels.PcehrView
{
    /// <summary>
    /// View model for a document category.
    /// </summary>
    public class DocumentCategoryViewModel
    {
        #region Properties

        /// <summary>
        /// Gets the auto-generated unique identifier for the document category.
        /// </summary>
        public string CategoryUniqueId { get; private set; }

        /// <summary>
        /// Gets or sets the code for the document category.
        /// </summary>
        public string CategoryCode { get; set; }

        /// <summary>
        /// Gets or sets the name of the document category.
        /// </summary>
        public string CategoryName { get; set; }

        /// <summary>
        /// Gets or sets a value that indicates if service dates are relevant to the document category.
        /// </summary>
        public bool AreServiceDatesRelevant { get; set; }

        /// <summary>
        /// Gets or sets the count of documents belonging to the document category.
        /// </summary>
        public int Count { get; set; }

        #endregion Properties

        #region Constructors

        /// <summary>
        /// Constructor.
        /// </summary>
        public DocumentCategoryViewModel()
        {
            this.CategoryUniqueId = System.Guid.NewGuid().ToString();
        }

        #endregion Constructors
    }
}