﻿using System.ComponentModel.DataAnnotations;

namespace HIPS.Web.UI.ViewModels.PcehrView
{
    /// <summary>
    /// Enumerates the types of access that can be requested.
    /// </summary>
    public enum AccessType
    {
        Unspecified = 0,
        WithCode = 1,
        Emergency = 2
    }

    /// <summary>
    /// View model for gaining access to the PCEHR for a selected patient.
    /// </summary>
    public class GainAccessViewModel : PcehrViewModelBase
    {
        #region Properties

        /// <summary>
        /// Gets or sets the return URL.
        /// </summary>
        public string ReturnUrl { get; internal set; }

        /// <summary>
        /// Gets or sets the access code entered by the user.
        /// </summary>
        [Display(Name = "Access Code")]
        public string AccessCode { get; internal set; }

        /// <summary>
        /// Gets or sets the access type selected by the user.
        /// </summary>
        public AccessType AccessType { get; internal set; }

        #endregion Properties

        #region Constructors

        /// <summary>
        /// Constructor.
        /// </summary>
        public GainAccessViewModel()
        {
        }

        #endregion Constructors
    }
}