/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.common.util;

import com.sun.xml.registry.common.util.XMLUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.server.UID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Node;

public class MarshallerUtil {
    Logger logger = Logger.getLogger("javax.enterprise.resource.webservices.registry.common");
    private static MarshallerUtil instance = null;
    private String jaxrHome = null;
    private JAXBContext jc = JAXBContext.newInstance("com.sun.xml.registry.uddi.bindings_v2_2");

    protected MarshallerUtil() throws JAXBException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MarshallerUtil getInstance() throws JAXBException {
        if (instance != null) return instance;
        Class<MarshallerUtil> clazz = MarshallerUtil.class;
        synchronized (MarshallerUtil.class) {
            if (instance != null) return instance;
            instance = new MarshallerUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public SOAPMessage jaxbMarshalObject(Object object) throws JAXBException {
        SOAPMessage sOAPMessage = null;
        Marshaller marshaller = this.jc.createMarshaller();
        try {
            MessageFactory messageFactory = MessageFactory.newInstance();
            sOAPMessage = messageFactory.createMessage();
            sOAPMessage.setProperty("javax.xml.soap.write-xml-declaration", "true");
            marshaller.marshal(object, sOAPMessage.getSOAPBody());
        }
        catch (SOAPException sOAPException) {
            throw new JAXBException(sOAPException);
        }
        return sOAPMessage;
    }

    public Object jaxbUnmarshalInputStream(InputStream inputStream) throws JAXBException {
        Unmarshaller unmarshaller = this.jc.createUnmarshaller();
        Object object = unmarshaller.unmarshal(inputStream);
        return object;
    }

    public OutputStream jaxbMarshalOutStream(Object object) throws JAXBException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Marshaller marshaller = this.jc.createMarshaller();
        marshaller.marshal(object, byteArrayOutputStream);
        return byteArrayOutputStream;
    }

    public Object jaxbUnmarshalObject(Node node) throws JAXBException {
        Unmarshaller unmarshaller = this.jc.createUnmarshaller();
        Object object = unmarshaller.unmarshal(node);
        return object;
    }

    public static String generateUUID() {
        String string2 = null;
        try {
            string2 = InetAddress.getLocalHost() + new UID().toString();
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
        }
        return string2;
    }

    public void log(SOAPMessage sOAPMessage) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            sOAPMessage.writeTo(byteArrayOutputStream);
        }
        catch (SOAPException sOAPException) {
            sOAPException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.log(byteArrayOutputStream);
    }

    private void log(ByteArrayOutputStream byteArrayOutputStream) {
        String string2 = byteArrayOutputStream.toString();
        if (this.logger.isLoggable(Level.FINEST)) {
            if (string2.indexOf("get_authToken") != -1) {
                XMLUtil.getInstance();
                this.logger.finest(XMLUtil.authToken2XXX(string2));
            } else if (string2.indexOf("authInfo") != -1) {
                XMLUtil.getInstance();
                this.logger.finest(XMLUtil.authInfo2XXX(string2));
            } else {
                this.logger.finest(string2);
            }
        }
    }
}

