﻿using System.ServiceModel;

using HIPS.ServiceContracts.Pcehr;
using HIPS.ServiceContracts.Pcehr.Message;

namespace HIPS.Client.Proxy
{
    /// <summary>
    /// This pre-built client class can be referenced by a .net client application in lieu of generating client classes from the WSDL.
    /// </summary>
    public class PcehrServiceV2Proxy : ClientBase<IPcehrServiceV2>, IPcehrServiceV2
    {
        /// <summary>
        /// Default constructor
        /// </summary>
        /// <param name="endpointName"></param>
        public PcehrServiceV2Proxy(string endpointName)
            : base(endpointName)
        {
        }

        /// <summary>
        /// This operation looks up a patient record in the current facility (for advertised status) and disclosure facility (for disclosed status),
        /// gets a validated IHI for the patient, and optionally refreshes the advertised status from the PCEHR system.
        /// </summary>
        /// <param name="request">RefreshPatientParticipationStatusRequest request parameters</param>
        public RefreshPatientParticipationStatusResponse RefreshPatientParticipationStatus(RefreshPatientParticipationStatusRequest request)
        {
            return Channel.RefreshPatientParticipationStatus(request);
        }

        /// <summary>
        /// Uploads a PDF discharge summary to the PCEHR National Repository, optionally superseding a previously-uploaded document.
        /// This takes in the PDF document, required metadata, and any attachments and creates a CDA document before packaging it.
        /// </summary>
        /// <param name="request">Request containing a PDF and required metadata for creating the CDA package.</param>
        /// <returns>Response indicating that the request was queued or the reason why not.</returns>
        public UploadDischargeSummaryLevel1AResponse UploadOrSupersedeDischargeSummaryLevel1A(UploadDischargeSummaryLevel1ARequest request)
        {
            return Channel.UploadOrSupersedeDischargeSummaryLevel1A(request);
        }
    }
}