﻿using System.Collections.Generic;
using System.ServiceModel;
using HIPS.BusinessEntities.ResponseEntities;
using HIPS.CommonSchemas;
using HIPS.PcehrDataStore.Schemas;
using HIPS.Reference.ServiceContracts;

namespace HIPS.Client.Proxy
{
    public class ReferenceProxy : ClientBase<IHIPSReferenceService>, IHIPSReferenceService
    {
        /// <summary>
        /// Default constructor
        /// </summary>
        /// <param name="endpointName"></param>
        public ReferenceProxy(string endpointName)
            : base(endpointName)
        {
        }

        /// <summary>
        /// Gets the hospital details.
        /// </summary>
        /// <param name="hospitalCode">The hospital code.</param>
        /// <param name="hospitalCodeSystem">The hospital code system.</param>
        /// <returns></returns>
        public HospitalDetailResponse GetHospitalDetails(string hospitalCode, string hospitalCodeSystem)
        {
            return Channel.GetHospitalDetails(hospitalCode, hospitalCodeSystem);
        }

        /// <summary>
        /// Lists the hospitals.
        /// </summary>
        /// <returns></returns>
        public List<Hospital> ListHospitals()
        {
            return Channel.ListHospitals();
        }

        /// <summary>
        /// Reloads all the reference data from the database.
        /// See <see cref="HIPS.CommonBusinessLogic.Singleton.ListSingleton"/> for
        /// further details of which reference data is loaded.
        /// </summary>
        /// <param name="user">User details</param>
        /// <returns>Indicator of success or failure</returns>
        public HipsResponse ReloadReferenceData(UserDetails user)
        {
            return Channel.ReloadReferenceData(user);
        }
    }
}