﻿using System;
using System.Diagnostics;
using HIPS.Base.Schemas;
using HIPS.CommonSchemas;
using HIPS.PcehrDataStore.DataAccess;
using HIPS.PcehrDataStore.Schemas.Enumerators;

namespace HIPS.Common.DataStore.DataAccess
{
    /// <summary>
    /// This class handles the event logging
    /// </summary>
    public static class EventLogger
    {
        /// <summary>
        /// Writes the message and exception details to the SystemErrorLog table.
        /// If unable to write in the SystemErrorLog table then writes an entry
        /// in the Windows event log.
        /// </summary>
        /// <param name="message">The message.</param>
        /// <param name="ex">The exception (optional).</param>
        public static void WriteLog(string message, Exception ex, UserDetails user, LogMessage logMessage)
        {
            SystemErrorLogDl dataAccess = new SystemErrorLogDl(user);
            SystemErrorLog errorMessage = new SystemErrorLog();
            errorMessage.LogMessageId = (int)logMessage;
            errorMessage.Message = message;
            if (ex != null)
            {
                errorMessage.ExceptionMessage = ex.Message;
            }
            try
            {
                dataAccess.Insert(errorMessage);
            }
            catch (Exception e)
            {
                string logEntry;
                if (ex != null)
                {
                    logEntry = string.Format(ConstantsResource.UnableToWriteExceptionToSystemErrorLog, e.Message, message, ex.Message);
                }
                else
                {
                    logEntry = string.Format(ConstantsResource.UnableToWriteMessageToSystemErrorLog, e.Message, message);
                }
                EventLog log = new EventLog();
                log.Source = "Application";
                log.WriteEntry(logEntry, EventLogEntryType.Error);
            }
        }
    }
}