﻿using System;
using HIPS.PcehrDataStore.DataAccess;
using HIPS.PcehrDataStore.Schemas;

namespace HIPS.CommonBusinessLogic.Ihi
{
    /// <summary>
    /// This class handles all the business logic for the IHI Lookup Audit;
    /// </summary>
    public static class IhiLookupAlertBl
    {
        /// <summary>
        /// Inserts the specified message.
        /// </summary>
        /// <param name="message">The message.</param>
        /// <param name="request">The request.</param>
        /// <param name="response">The response.</param>
        public static void Insert(int patientMasterId, string message, string request, string response)
        {
            IhiLookupAlert item = new IhiLookupAlert();
            item.PatientMasterId = patientMasterId;
            item.Message = message;
            item.Request = request;
            item.Response = response;
            IhiLookupAlertDl dataAccess = new IhiLookupAlertDl();
            if (!dataAccess.Insert(item))
            {
                throw new Exception(string.Format(ConstantsResource.DatabaseError, dataAccess.GetType().FullName));
            }
        }
    }
}