﻿namespace HIPS.CommonSchemas.Cda
{
    /// <summary>
    /// Represents an attachment to a CDA document with a caption.
    /// </summary>
    public class CdaAttachment
    {
        /// <summary>
        /// Gets or sets the type of attachment, including whether it is the
        /// organisational logo, the main document, or additional attached
        /// images or documents.
        /// </summary>
        public AttachmentType AttachmentType { get; set; }

        /// <summary>
        /// Gets or sets the caption that will appear on the link to this file within the CDA document.
        /// </summary>
        public string Caption { get; set; }

        /// <summary>
        /// Binary content of the file.
        /// </summary>
        public byte[] Content { get; set; }

        /// <summary>
        /// Name of the file.
        /// </summary>
        public string FileName { get; set; }
    }
}