﻿using System.Runtime.Serialization;

namespace HIPS.CommonSchemas.PatientIdentifier
{
    /// <summary>
    /// This Patient Identifier is used for the StatePatientIdentifier
    /// </summary>

    [DataContract]
    public class StatePatientId : PatientIdentifierBase
    {
        #region Private Members

        private string statePatientId;

        #endregion Private Members

        #region Methods

        /// <summary>
        /// Gets or sets the StatePatientId
        /// </summary>
        /// <value>
        /// Value
        /// </value>
        [DataMember]
        public string Value
        {
            get
            {
                return statePatientId;
            }
            set
            {
                statePatientId = value;
            }
        }

        #endregion Methods

        #region Methods

        /// <summary>
        /// Initialises a new instance of the <see cref="StatePatientId" /> class. This basic constructor is used by AutoMapper.
        /// </summary>
        public StatePatientId()
        {
        }

        /// <summary>
        /// Specific constructor for the state patient identifier.
        /// </summary>
        /// <param name="statePatientId">The state patient identifier (SAUHI, HCID)</param>
        /// <param name="hospitalCode">The hospital code</param>
        /// <param name="hospitalCodeSystem">The hospital code system</param>
        public StatePatientId(string statePatientId, string hospitalCode, string hospitalCodeSystem)
            : base(hospitalCode, hospitalCodeSystem)
        {
            this.statePatientId = statePatientId;
        }

        /// <summary>
        /// Represents the StatePatientId patient identifier as a string for logging and debugging purposes.
        /// </summary>
        /// <returns>A string representation of the object.</returns>
        public override string ToString()
        {
            return string.Format("State Patient Id: {0}", statePatientId);
        }

        #endregion Methods
    }
}