﻿using System;
using System.Runtime.Serialization;
using HIPS.PcehrDataStore.Schemas.Enumerators;

namespace HIPS.IhiSchemas.Schemas
{
    /// <summary>
    /// This class represents one combination within a set of IHI search criteria.
    /// </summary>
    [KnownType(typeof(IhiSearchCriteriaName))]
    [Serializable]
    [DataContract]
    public class IhiSearchCriteriaName
    {
        #region Backing Fields

        private DateTime? dateOfBirth;
        private string familyName;
        private string givenName;
        private SexEnumerator sex;
        private int? suffixId;
        private int? titleId;

        #endregion Backing Fields

        #region Properties

        /// <summary>
        /// Gets or sets the Registered Date of Birth.
        /// </summary>
        /// <value>
        /// The Registered Date of Birth.
        /// </value>
        [DataMember]
        public DateTime? DateOfBirth
        {
            get
            {
                return dateOfBirth;
            }
            set
            {
                dateOfBirth = value;
            }
        }

        /// <summary>
        /// Gets or sets the family name.
        /// </summary>
        /// <value>
        /// The family name.
        /// </value>
        [DataMember]
        public string FamilyName
        {
            get
            {
                return familyName;
            }
            set
            {
                familyName = value;
            }
        }

        /// <summary>
        /// Gets or sets the given names.
        /// </summary>
        /// <value>
        /// The given names.
        /// </value>
        [DataMember]
        public string GivenName
        {
            get
            {
                return givenName;
            }
            set
            {
                givenName = value;
            }
        }

        /// <summary>
        /// Gets or sets the current sex.
        /// </summary>
        /// <value>
        /// The current sex.
        /// </value>
        [DataMember]
        public SexEnumerator Sex
        {
            get
            {
                return sex;
            }
            set
            {
                sex = value;
            }
        }

        /// <summary>
        /// Gets or sets the suffix ID.
        /// </summary>
        /// <value>
        /// The suffix ID.
        /// </value>
        [DataMember]
        public int? SuffixId
        {
            get
            {
                return suffixId;
            }
            set
            {
                suffixId = value;
            }
        }

        /// <summary>
        /// Gets or sets the title ID.
        /// </summary>
        /// <value>
        /// The title ID.
        /// </value>
        [DataMember]
        public int? TitleId
        {
            get
            {
                return titleId;
            }
            set
            {
                titleId = value;
            }
        }

        #endregion Properties
    }
}