﻿using System;
using System.Collections.Generic;
using System.Data.SqlClient;
using HIPS.Common.DataStore.DataAccess;
using HIPS.Common.PcehrDataStore.DataAccess;
using HIPS.PcehrDataStore.Schemas.Enumerators;
using HIPS.PcehrDataStore.Schemas.Schemas;

namespace HIPS.PcehrDataStore.DataAccess
{
    internal class HospitalAddressDl : BaseDl
    {
        #region Methods

        /// <summary>
        /// Gets all the addresses for a specific hospital or for all hospitals.
        /// </summary>
        /// <param name="hospitalId">The hospital id, or null for all hospitals</param>
        /// <returns></returns>
        public List<Address> GetAll(int? hospitalId)
        {
            List<Address> results = new List<Address>();
            try
            {
                using (SqlCommand command = GetSqlCommand("hips.HospitalAddressGet"))
                {
                    if (hospitalId != null)
                    {
                        command.Parameters.Add(new SqlParameter("@HospitalId", hospitalId));
                    }
                    results = GetPopulatedBusinessList<Address>(command.ExecuteReader());
                    command.Connection.Close();
                }
            }
            catch (Exception ex)
            {
                EventLogger.WriteLog(ConstantsResource.ErrorHospitalAddressGetAll, ex, User, LogMessage.HIPS_MESSAGE_133);
            }
            return results;
        }

        #endregion Methods
    }
}