﻿using System;
using System.Collections.Generic;
using System.Data.SqlClient;
using HIPS.Common.DataStore.DataAccess;
using HIPS.Common.PcehrDataStore.DataAccess;
using HIPS.PcehrDataStore.Schemas;
using HIPS.PcehrDataStore.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.DataAccess
{
    /// <summary>
    /// This class allows access to the MedicareExclusion table
    /// </summary>
    public class MedicareExclusionDl : BaseDl
    {
        #region Methods

        /// <summary>
        /// Gets the specified MedicareExclusion id.
        /// </summary>
        /// <param name="MedicareExclusionId">The MedicareExclusion id.</param>
        /// <returns></returns>
        public MedicareExclusion Get(int MedicareExclusionId)
        {
            MedicareExclusion result = new MedicareExclusion();
            try
            {
                using (SqlCommand command = GetSqlCommand("hips.MedicareExclusionGet"))
                {
                    command.Parameters.Add(new SqlParameter("@MedicareExclusionId", MedicareExclusionId));
                    PopulateBusinessObject<MedicareExclusion>(command.ExecuteReader(), result);
                    command.Connection.Close();
                }
            }
            catch (Exception ex)
            {
                EventLogger.WriteLog(ConstantsResource.ErrorMessageMedicareExclusionGet, ex, User, LogMessage.HIPS_MESSAGE_029);
            }
            return result;
        }

        /// <summary>
        /// Gets all.
        /// </summary>
        /// <returns></returns>
        public List<MedicareExclusion> GetAll()
        {
            return GetAll(null);
        }

        /// <summary>
        /// Gets all.
        /// </summary>
        /// <returns></returns>
        public List<MedicareExclusion> GetAll(DateTime? lastUpdated)
        {
            List<MedicareExclusion> results = new List<MedicareExclusion>();
            try
            {
                using (SqlCommand command = GetSqlCommand("hips.MedicareExclusionGet"))
                {
                    if (lastUpdated.HasValue)
                    {
                        command.Parameters.Add(new SqlParameter("@DateModified", lastUpdated));
                    }
                    results = GetPopulatedBusinessList<MedicareExclusion>(command.ExecuteReader());
                    command.Connection.Close();
                }
            }
            catch (Exception ex)
            {
                EventLogger.WriteLog(ConstantsResource.ErrorMessageMedicareExclusionGet, ex, User, LogMessage.HIPS_MESSAGE_028);
            }
            return results;
        }

        #endregion Methods
    }
}