﻿using HIPS.Base.Schemas;
using HIPS.Base.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.Schemas
{
    /// <summary>
    /// Represents the data returned from the database for a patient in hospital.
    /// </summary>
    public class PatientDisclosureDetails
    {
        /// <summary>
        /// Gets or sets the Audit Information from the most recent change to
        /// the disclosure status of the patient.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public byte[] DisclosureAuditInformation { get; set; }

        /// <summary>
        /// Gets or sets details about the admitted patient.
        /// </summary>
        public PatientInHospital PatientInHospital { get; set; }
    }
}