﻿using System;
using HIPS.Base.Schemas;
using HIPS.Base.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.Schemas
{
    /// <summary>
    /// Represents the data returned from the database for a patient in hospital.
    /// </summary>
    public class PatientInHospital
    {
        /// <summary>
        /// The admission date of the patient's most recent matching episode.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public DateTime AdmissionDate { get; set; }

        /// <summary>
        /// The admission reason of the most recent episode of the patient.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string AdmissionReason { get; set; }

        /// <summary>
        /// The current Bed of the patient's most recent matching episode.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string Bed { get; set; }

        /// <summary>
        /// Whether the patient has withdrawn consent for the most recent matching episode.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public bool? ConsentWithdrawn { get; set; }

        /// <summary>
        /// The patients's current sex identifier.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public int CurrentSexId { get; set; }

        /// <summary>
        /// The patients's Date of Birth.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public DateTime DateOfBirth { get; set; }

        /// <summary>
        /// The discharge date of the patient's most recent matching episode.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public DateTime? DischargeDate { get; set; }

        /// <summary>
        /// The patients's DVA Number.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string DvaNumber { get; set; }

        /// <summary>
        /// Number of episodes that fall within the 'days since discharge' criteria.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public int EpisodeCount { get; set; }

        /// <summary>
        /// The patients's family name.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string FamilyName { get; set; }

        /// <summary>
        /// The patient's given names.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string GivenNames { get; set; }

        /// <summary>
        /// The hospital code of the hospital in which the patient is or was admitted.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string HospitalCode { get; set; }

        /// <summary>
        /// The primary key of the hospital in which the patient is or was admitted.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public int HospitalId { get; set; }

        /// <summary>
        /// The name of the hospital in which the patient is or was admitted.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string HospitalName { get; set; }

        /// <summary>
        /// The patients's IHI.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string Ihi { get; set; }

        /// <summary>
        /// The patients's IHI last validated date.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public DateTime? IhiLastValidated { get; set; }

        /// <summary>
        /// The patients's IHI record status.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public int IhiRecordStatusId { get; set; }

        /// <summary>
        /// The patients's IHI status.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public int IhiStatusId { get; set; }

        /// <summary>
        /// The patients's Medicare IRN.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string MedicareIrn { get; set; }

        /// <summary>
        /// The patients's Medicare Number.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string MedicareNumber { get; set; }

        /// <summary>
        /// The patient's MRN at the hospital where the patient was admitted.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string Mrn { get; set; }

        /// <summary>
        /// The patient's master identifier.
        /// </summary>
        public int PatientMasterId { get; set; }

        /// <summary>
        /// Whether the patient has a PCEHR that is advertised (not hidden).
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public bool? PcehrAdvertised { get; set; }

        /// <summary>
        /// Whether the patient has explicitly disclosed the existence of his/her PCEHR.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public bool? PcehrDisclosed { get; set; }

        /// <summary>
        /// The patients's Medicare registered family name.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string RegisteredFamilyName { get; set; }

        /// <summary>
        /// The patient's Medicare registered given name.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string RegisteredGivenName { get; set; }

        /// <summary>
        /// The patients's Medicare registered sex identifier.
        /// </summary>
        public int? RegisteredSexId { get; set; }

        /// <summary>
        /// The family name of the responsible provider for the most recent matching episode.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string ResponsibleProviderFamilyName { get; set; }

        /// <summary>
        /// The given names of the responsible provider.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string ResponsibleProviderGivenNames { get; set; }

        /// <summary>
        /// The suffix of the responsible provider (such as 'Jr' or 'Sr').
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string ResponsibleProviderSuffix { get; set; }

        /// <summary>
        /// The title of the responsible provider (such as 'Dr', 'Ms' or 'Mr').
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string ResponsibleProviderTitle { get; set; }

        /// <summary>
        /// The current Room of the patient's most recent matching episode.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string Room { get; set; }

        /// <summary>
        /// The external ID of the most recent matching episode for the patient.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string SourceSystemEpisodeId { get; set; }

        /// <summary>
        /// The patient's name suffixes (like "Jr")
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string Suffix { get; set; }

        /// <summary>
        /// The patients's titles (like "Dr", "Ms" or "Mr")
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string Title { get; set; }

        /// <summary>
        /// The current Ward of the patient's most recent matching episode.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string Ward { get; set; }
    }
}