﻿using System;
using HIPS.CommonSchemas;

namespace HIPS.PcehrSchemas.Exceptions
{
    /// <summary>
    /// This exception is thrown when the PCEHR Service is unavailable.
    /// </summary>
    public class PcehrServiceUnavailableException : Exception
    {
        /// <summary>
        /// Gets or sets the details of the PCEHR service error.
        /// </summary>
        public HipsResponse Detail { get; set; }

        /// <summary>
        /// Initialises a new instance of the <see cref="PcehrServiceUnavailableException"/> class.
        /// </summary>
        /// <param name="detail">The details of the PCEHR service error.</param>
        /// <param name="innerException">The inner exception.</param>
        public PcehrServiceUnavailableException(HipsResponse detail, Exception innerException)
            : base(detail.HipsErrorMessage, innerException)
        {
            this.Detail = detail;
        }
    }
}