﻿using System;
using System.Runtime.Serialization;

namespace HIPS.PcehrSchemas
{
    /// <summary>
    /// This object is used to pass the request to access the view from the PCEHR system.
    /// </summary>
    [KnownType(typeof(PrescriptionAndDispenseViewRequest))]
    [Serializable]
    [DataContract]
    public abstract class ViewRequestBase
    {
        /// <summary>
        /// Maps this object to the corresponding NEHTA library object.
        /// </summary>
        /// <returns>The NEHTA library object.</returns>
        public abstract object ToNehtaLibraryObject();
    }
}