﻿using System.Runtime.Serialization;

using EntLibVal = Microsoft.Practices.EnterpriseLibrary.Validation;

namespace HIPS.ServiceContracts.Common.DTO
{
    /// <summary>
    /// Electronic Communication Detail DTO. This object represents a telephone number,
    /// mobile number, fax number, pager number, email address or internet address.
    /// </summary>
    [DataContract(Namespace = HIPS.ServiceContracts.Common.Constants.ServiceNamespace.COMMON_V1)]
    public class ElectronicCommunicationDetail
    {
        /// <summary>
        /// Gets or sets the value of the number or address.
        /// </summary>
        [DataMember(IsRequired = true)]
        [EntLibVal.Validators.StringLengthValidator(1, 1024)]
        public string Detail { get; set; }

        /// <summary>
        /// Gets or sets the communication medium.
        /// </summary>
        [DataMember(IsRequired = true)]
        [EntLibVal.Validators.DomainValidator(ElectronicCommunicationMedium.None, Negated = true)]
        public ElectronicCommunicationMedium Medium { get; set; }

        /// <summary>
        /// Gets or sets the usage of the communication method.
        /// </summary>
        [DataMember(IsRequired = false)]
        public ElectronicCommunicationUsage Usage { get; set; }
    }
}