﻿using System.Runtime.Serialization;

namespace HIPS.ServiceContracts.Common.DTO
{
    /// <summary>
    /// This DTO is used to identify a hospital / facility.
    /// </summary>
    [DataContract(Namespace = HIPS.ServiceContracts.Common.Constants.ServiceNamespace.COMMON_V1)]
    public class HospitalIdentifier
    {
        /// <summary>
        /// Gets or sets a code that identifies a hospital facility, within the code system specified in the HospitalCodeSystem property.
        /// </summary>
        [DataMember(IsRequired = true)]
        public string HospitalCode { get; set; }

        /// <summary>
        /// Gets or sets a code that identifies the code system in which the HospitalCode is defined.
        /// </summary>
        [DataMember(IsRequired = true)]
        public string HospitalCodeSystem { get; set; }
    }
}